<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapListCMD $params)
 * @method detailByParams(array $params)
 * @method saveByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapSaveCMD $params)
 * @method getScrapItemsSortByCategoryByParams(array $params)
 * @method missionListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionListCMD $params)
 * @method missionDetailByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $params)
 * @method missionsDetailByParams(array $params)
 * @method missionCreateByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $params)
 * @method missionRevokeByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $params)
 * @method missionProcessByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionProcessCMD $params)
 * @method missionProcessRateByParams(array $params)
 * @method storeInMissionByParams(array $params)
 * @method skuInMissionsByParams(array $params)
 * @method storeDealScrapByParams(array $params)
 * @method itemAllListByParams(array $params)
 * @method dingCallBackByParams(array $params)
 */
class Scrap {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店报废单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapListCMD $listCMD
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapListCMD $listCMD) {
        return self::getClass()->list($listCMD);
    }


    /**
     * 报废单详情
     *
     * @support  int $scrapId 报废单id [ require false ]
     * @support  string $scrapNo 报废单编号 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 提交报废单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapSaveCMD $saveCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function save (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapSaveCMD $saveCMD) {
        return self::getClass()->save($saveCMD);
    }


    /**
     * 分类排序返回报废数据
     *
     * @support  int $scrapId scrapId [ require true ]
     * @support  int $page page [ require false ]
     * @support  int $pageSize pageSize [ require false ]
     * @support  bool $isPaginate 是否分页 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getScrapItemsSortByCategory () {
        return self::getClass()->getScrapItemsSortByCategory([
        ]);
    }

    /**
     * 报废任务列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionListCMD $listCMD
     * @throws  \Exception
     * @return  array
     */
    public static function missionList (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionListCMD $listCMD) {
        return self::getClass()->missionList($listCMD);
    }


    /**
     * 报废任务详情
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $detailCMD
     * @throws  \Exception
     * @return  array
     */
    public static function missionDetail (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionDetailCMD $detailCMD) {
        return self::getClass()->missionDetail($detailCMD);
    }


    /**
     * 获取指定报废任务ids的详情
     *
     * @support  array $missionIds 任务IDs [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function missionsDetail () {
        return self::getClass()->missionsDetail([
        ]);
    }

    /**
     * 新增报废任务
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $createCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function missionCreate (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $createCMD) {
        return self::getClass()->missionCreate($createCMD);
    }


    /**
     * 盘点任务撤回
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function missionRevoke (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $CMD) {
        return self::getClass()->missionRevoke($CMD);
    }


    /**
     * 报废进度
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionProcessCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function missionProcess (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionProcessCMD $CMD) {
        return self::getClass()->missionProcess($CMD);
    }


    /**
     * 报废进度计算
     *
     * @param  int $missionId 任务ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function missionProcessRate (int $missionId) {
        return self::getClass()->missionProcessRate([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 报废任务关联门店
     *
     * @param  int $missionId 任务ID [ require true ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $status 审核状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeInMission (int $missionId) {
        return self::getClass()->storeInMission([
            "missionId" => $missionId,
        ]);
    }

    /**
     * 报废任务关联sku
     *
     * @param  array $missionIds 任务IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function skuInMissions (array $missionIds) {
        return self::getClass()->skuInMissions([
            "missionIds" => $missionIds,
        ]);
    }

    /**
     * 门店待处理报废单数量
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeDealScrap (int $storeId) {
        return self::getClass()->storeDealScrap([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 所有报废明细
     *
     * @param  array $scrapIds 报废IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemAllList (array $scrapIds) {
        return self::getClass()->itemAllList([
            "scrapIds" => $scrapIds,
        ]);
    }

    /**
     * 报废审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function dingCallBack () {
        return self::getClass()->dingCallBack();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Scrap');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Scrap');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}