<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProcessOrderBySkuIdByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderItemCmd $params)
 */
class ProcessOrderItem {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询加工单明细数据
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderItemCmd $param
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessOrderBySkuId (\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderItemCmd $param) {
        return self::getClass()->getProcessOrderBySkuId($param);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ProcessOrderItem');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ProcessOrderItem');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}