<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method missionCreateByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $params)
 * @method missionRevokeByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $params)
 * @method missionProcessByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionProcessCMD $params)
 * @method missionProcessRateByParams(array $params)
 */
class Scrap {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增报废任务
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $createCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function missionCreate (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionCreateCMD $createCMD) {
        return self::getClass()->missionCreate($createCMD);
    }


    /**
     * 盘点任务撤回
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function missionRevoke (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionRevokeCMD $CMD) {
        return self::getClass()->missionRevoke($CMD);
    }


    /**
     * 报废进度
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionProcessCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function missionProcess (\Mainto\Bridge\Structs\HimoSupplyChain\Scrap\Cmd\ScrapMissionProcessCMD $CMD) {
        return self::getClass()->missionProcess($CMD);
    }


    /**
     * 报废进度计算
     *
     * @param  int $missionId 任务ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function missionProcessRate (int $missionId) {
        return self::getClass()->missionProcessRate([
            "missionId" => $missionId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Scrap');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Scrap');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}