<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createReturnByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnCreateCMD $params)
 * @method approvalRevokeByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnApprovalRevokeCMD $params)
 * @method updateStatusByParams(array $params)
 * @method getDetailByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnDetailQuery $params)
 * @method getCreatInfoByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnCreateInfoQuery $params)
 * @method getListPaginationByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params)
 * @method getListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params)
 * @method getReturnItemCountByParams(array $params)
 * @method retryReturnEbsByParams(array $params)
 * @method dingCallBackByParams(array $params)
 */
class PurchaseReturn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退货单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnCreateCMD $purchaseReturnCreateCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO
     */
    public static function createReturn (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnCreateCMD $purchaseReturnCreateCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createReturn($purchaseReturnCreateCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO"
        );
    }


    /**
     * 审批单撤回
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnApprovalRevokeCMD $purchaseReturnApprovalRevokeCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function approvalRevoke (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnApprovalRevokeCMD $purchaseReturnApprovalRevokeCMD) {
        return self::getClass()->approvalRevoke($purchaseReturnApprovalRevokeCMD);
    }


    /**
     * 更新状态
     *
     * @param  int $returnId 退货单id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStatus (int $returnId, string $status) {
        return self::getClass()->updateStatus([
            "returnId" => $returnId,
            "status" => $status,
        ]);
    }

    /**
     * 获取退货单子单(退货单主单详情）
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnDetailQuery $query
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO
     */
    public static function getDetail (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnDetailQuery $query) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDetail($query),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO"
        );
    }


    /**
     * 创建时获取明细
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnCreateInfoQuery $query
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnCreateInfoDTO
     */
    public static function getCreatInfo (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\ReturnCreateInfoQuery $query) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCreatInfo($query),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnCreateInfoDTO"
        );
    }


    /**
     * 分页查询退货单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $pageQuery
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnPageDTO
     */
    public static function getListPagination (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $pageQuery) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getListPagination($pageQuery),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnPageDTO"
        );
    }


    /**
     * 退货单列表不分页
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnListDTO[]
     */
    public static function getList (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList($params),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnListDTO[]"
        );
    }


    /**
     * 根据noticemItemIds,orderItemIds 来返回对应的退货单数量
     *
     * @support  array $noticeItemIds 发货通知单子单id [ require false ]
     * @support  array $orderItemIds 采购订单子单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReturnItemCount () {
        return self::getClass()->getReturnItemCount([
        ]);
    }

    /**
     * ebs重推
     *
     * @support  int $returnId 退货单主单id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retryReturnEbs () {
        return self::getClass()->retryReturnEbs([
        ]);
    }

    /**
     * 退回单审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function dingCallBack () {
        return self::getClass()->dingCallBack();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseReturn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseReturn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}