<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createReturnByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnCreateCMD $params)
 * @method purchaseReturnOutStorageByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params)
 * @method getListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params)
 * @method getReturnItemCountByParams(array $params)
 * @method getReturnTaxByParams(array $params)
 * @method retryReturnEbsByParams(array $params)
 */
class PurchaseReturn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退货单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnCreateCMD $purchaseReturnCreateCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO
     */
    public static function createReturn (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnCreateCMD $purchaseReturnCreateCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createReturn($purchaseReturnCreateCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\DTO\PurchaseReturnDTO"
        );
    }


    /**
     * 退货单出库（预留接口）
     *
     * @support  int $returnId 退货单id [ require true ]
     * @support  int $operateId 操作人id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function purchaseReturnOutStorage () {
        return self::getClass()->purchaseReturnOutStorage([
        ]);
    }

    /**
     * getItems
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems();
    }

    /**
     * 分页查询退货单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $pageQuery
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $pageQuery) {
        return self::getClass()->getListPagination($pageQuery);
    }


    /**
     * 退货单列表不分页
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params
     * @throws  \Exception
     * @return  array
     */
    public static function getList (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseReturns\Model\CMD\PurchaseReturnPageQuery $params) {
        return self::getClass()->getList($params);
    }


    /**
     * 根据noticemItemIds,orderItemIds 来返回对应的退货单数量
     *
     * @support  array $noticeItemIds 发货通知单子单id [ require false ]
     * @support  array $orderItemIds 采购订单子单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReturnItemCount () {
        return self::getClass()->getReturnItemCount([
        ]);
    }

    /**
     * 根据returnId 来计算退货单的总金额，不含税，以及税额
     *
     * @support  int $returnId 退货单主单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReturnTax () {
        return self::getClass()->getReturnTax([
        ]);
    }

    /**
     * ebs重推
     *
     * @support  int $returnId 退货单主单id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retryReturnEbs () {
        return self::getClass()->retryReturnEbs([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseReturn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseReturn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}