<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateByParams(array $params)
 * @method revokeByParams(array $params)
 * @method submitByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method createByParams(array $params)
 * @method payByParams(array $params)
 * @method approveByParams(array $params)
 * @method firstByOrderIdByParams(array $params)
 * @method getByOrderIdsByParams(array $params)
 * @method closedDueByParams(array $params)
 */
class PurchaseDue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $dueNo 应付款单号 [ require false ]
     * @support  string $orderNo 采购单号 [ require false ]
     * @support  string $createdAtStart 创建开始时间 [ require false ]
     * @support  string $createdAtEnd 创建结束时间 [ require false ]
     * @support  int $createBy 创建人工号 [ require false ]
     * @support  string $approveStatus 审批状态 [ require false ]
     * @support  string $status 付款状态 [ require false ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  int $orderId 采购单Id [ require false ]
     * @support  string $advanceNo 预付单号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $dueId 应付款单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $dueId) {
        return self::getClass()->detail([
            "dueId" => $dueId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $dueId 应付款单id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $dueId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "dueId" => $dueId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $dueId 应付款单id [ require true ]
     * @support  int $supplierBankId 供应商账户id [ require false ]
     * @support  string $invoiceNumber 发票号 [ require false ]
     * @param  array $items 修改的子单数据 [ require true ]
     * @support  float $discount 优惠金额 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $dueId, int $updateBy, array $items) {
        return self::getClass()->update([
            "dueId" => $dueId,
            "updateBy" => $updateBy,
            "items" => $items,
        ]);
    }

    /**
     * 撤销审批
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $dueId 应付款单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function revoke (int $updateBy, int $dueId) {
        return self::getClass()->revoke([
            "updateBy" => $updateBy,
            "dueId" => $dueId,
        ]);
    }

    /**
     * 提交审批
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  int $dueId 应付款单id [ require true ]
     * @param  string $processInstanceId 审批id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function submit (int $updateBy, int $dueId, string $processInstanceId) {
        return self::getClass()->submit([
            "updateBy" => $updateBy,
            "dueId" => $dueId,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 创建应付账单
     *
     * @param  int $orderId 采购单id [ require true ]
     * @param  int $createBy 创建人工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $orderId, int $createBy) {
        return self::getClass()->create([
            "orderId" => $orderId,
            "createBy" => $createBy,
        ]);
    }

    /**
     * 更新付款
     *
     * @param  string $dueNo 单号 [ require true ]
     * @param  string $status 付款状态 [ require true ]
     * @param  mixed $paidMoney 付款金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function pay (string $dueNo, string $status, $paidMoney) {
        return self::getClass()->pay([
            "dueNo" => $dueNo,
            "status" => $status,
            "paidMoney" => $paidMoney,
        ]);
    }

    /**
     * 更新审批
     *
     * @param  string $processInstanceId 审批id [ require true ]
     * @param  string $approveStatus 审批状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function approve (string $processInstanceId, string $approveStatus) {
        return self::getClass()->approve([
            "processInstanceId" => $processInstanceId,
            "approveStatus" => $approveStatus,
        ]);
    }

    /**
     * 根据订单id获取预付单信息
     *
     * @param  int $orderId 采购单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function firstByOrderId (int $orderId) {
        return self::getClass()->firstByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据订单ids获取预付单信息
     *
     * @param  array $orderIds 采购单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByOrderIds (array $orderIds) {
        return self::getClass()->getByOrderIds([
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 应付账单关闭
     *
     * @param  int $dueId 采购单id [ require true ]
     * @param  int $updateBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closedDue (int $dueId, int $updateBy) {
        return self::getClass()->closedDue([
            "dueId" => $dueId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseDue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseDue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}