<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPredictDatesByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\PredictCMD $params)
 * @method getPredictDateItemsByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\PredictDateCMD $params)
 */
class Predict {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getPredictDates
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\PredictCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\PredictRetDTO
     */
    public static function getPredictDates (\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\PredictCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPredictDates($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\PredictRetDTO"
        );
    }


    /**
     * getPredictDateItems
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\PredictDateCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\PredictRetItemDTO[]
     */
    public static function getPredictDateItems (\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\PredictDateCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPredictDateItems($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\PredictRetItemDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Predict');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Predict');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}