<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createEntryByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 * @method approvalRevokeByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseEntry\CMD\PurchaseEntryApprovalRevokeCMD $params)
 * @method closePurchaseEntryByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseEntry\CMD\PurchaseEntryCloseCMD $params)
 * @method dingCallBackByParams(array $params)
 */
class PurchaseEntry {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建入库单
     *
     * @support  int $storageId 入库仓库id [ require false ]
     * @support  int $createdBy 操作人 [ require true ]
     * @support  string $content 备注 [ require false ]
     * @support  string $operationType 业务类型 [ require false ]
     * @support  int $source 来源 [ require false ]
     * @support  string $type 出入库类型 [ require false ]
     * @support  array $items 入库单列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createEntry () {
        return self::getClass()->createEntry([
        ]);
    }

    /**
     * getItems
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems();
    }

    /**
     * getListPagination
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination();
    }

    /**
     * getList
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * approvalRevoke
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseEntry\CMD\PurchaseEntryApprovalRevokeCMD $approvalRevokeCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function approvalRevoke (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseEntry\CMD\PurchaseEntryApprovalRevokeCMD $approvalRevokeCMD) {
        return self::getClass()->approvalRevoke($approvalRevokeCMD);
    }


    /**
     * closePurchaseEntry
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseEntry\CMD\PurchaseEntryCloseCMD $closePurchaseEntryCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function closePurchaseEntry (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseEntry\CMD\PurchaseEntryCloseCMD $closePurchaseEntryCMD) {
        return self::getClass()->closePurchaseEntry($closePurchaseEntryCMD);
    }


    /**
     * 退回单审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function dingCallBack () {
        return self::getClass()->dingCallBack();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseEntry');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseEntry');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}