<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseRefundByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateCMD $params)
 * @method submitPurchaseRefundByParams(array $params)
 * @method getRefundItemCountByParams(array $params)
 * @method updatePurchaseRefundByParams(array $params)
 * @method getItemsByParams(array $params)
 * @method getListPaginationByParams(array $params)
 * @method getListByParams(array $params)
 * @method getRefundTaxByParams(array $params)
 * @method getCreateInfoByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateInfoCMD $params)
 */
class PurchaseRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款单创建
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateCMD $purchaseRefundCreateInfoDTO
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseRefund (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateCMD $purchaseRefundCreateInfoDTO) {
        return self::getClass()->createPurchaseRefund($purchaseRefundCreateInfoDTO);
    }


    /**
     * 退款单提交/完成
     *
     * @support  int $refundId 退款单id [ require true ]
     * @support  int $updatedBy 操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitPurchaseRefund () {
        return self::getClass()->submitPurchaseRefund([
        ]);
    }

    /**
     * 根据noticemItemIds,orderItemIds 来返回对应的退货单数量
     *
     * @support  array $noticeItemIds 发货通知单子单id [ require false ]
     * @support  array $orderItemIds 采购订单子单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRefundItemCount () {
        return self::getClass()->getRefundItemCount([
        ]);
    }

    /**
     * 更新退款单
     *
     * @support  int $refundId 退款单id [ require true ]
     * @support  int $updatedBy 操作人id [ require true ]
     * @support  array $items 子单 [ require true ]
     * @support  float $refundMoney 退款金额 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updatePurchaseRefund () {
        return self::getClass()->updatePurchaseRefund([
        ]);
    }

    /**
     * getItems
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getItems () {
        return self::getClass()->getItems();
    }

    /**
     * getListPagination
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getListPagination () {
        return self::getClass()->getListPagination();
    }

    /**
     * getList
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 根据refundId 来计算退款的总金额，不含税，以及税额
     *
     * @support  int $refundId 退款单主单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRefundTax () {
        return self::getClass()->getRefundTax([
        ]);
    }

    /**
     * 退款单创建前信息
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateInfoCMD $purchaseRefundCreateInfoCMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\DTO\PurchaseRefundCreateInfoDTO
     */
    public static function getCreateInfo (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\CMD\PurchaseRefundCreateInfoCMD $purchaseRefundCreateInfoCMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCreateInfo($purchaseRefundCreateInfoCMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseRefund\DTO\PurchaseRefundCreateInfoDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}