<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method importByParams(array $params)
 * @method importTrackingNumberByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method sendByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemsByOrderItemIdsByParams(array $params)
 * @method getItemsByDemandItemIdsByParams(array $params)
 * @method getItemsByItemIdsByParams(array $params)
 * @method getByIdsByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSearchCMD $params)
 * @method getItemsByStatusAndNoticeIdsByParams(array $params)
 * @method getItemsByNoticeIdsByParams(array $params)
 * @method trySyncReceiveToWmsByParams(array $params)
 * @method searchShipNoticeByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $params)
 * @method changePlanShipDateByParams(array $params)
 * @method checkBmsShipByParams(array $params)
 * @method checkBmsNoticeItemIdsByParams(array $params)
 * @method batchSendItemsByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSendCMD $params)
 * @method getRedPointCountByStorageIdByParams(array $params)
 * @method searchSupplyShipNoticeItemsByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\SupplyShipNoticeItemSearchCMD $params)
 * @method getShopCountByStorageIdByParams(array $params)
 * @method pushToWmsByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\PushToWMSCMD $params)
 */
class PurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticePaginateDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticePaginateDTO"
        );
    }


    /**
     * 详情
     *
     * @support  int $noticeId 发货通知单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail([
        ]);
    }

    /**
     * 明细列表
     *
     * @support  int $noticeId 采购单id [ require false ]
     * @support  array $shipNoticeIds 主单ids [ require false ]
     * @support  string $timeStatus 时间状态 [ require false ]
     * @support  array $status 发货状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @support  array $sort 列表排序 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList () {
        return self::getClass()->itemList([
        ]);
    }

    /**
     * 导入快递单号和数量
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function import (int $updateBy, array $data) {
        return self::getClass()->import([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 导入快递单号
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTrackingNumber (int $updateBy, array $data) {
        return self::getClass()->importTrackingNumber([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量发运
     *
     * @param  int $createBy 更新人工号 [ require true ]
     * @support  int $updateBySupplyId 更新人工号 [ require false ]
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @support  int $source 发货通知单source [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSend (int $createBy, array $noticeIds) {
        return self::getClass()->batchSend([
            "createBy" => $createBy,
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 发运
     *
     * @param  int $createBy 更新人工号 [ require true ]
     * @param  int $noticeId 发货通知单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function send (int $createBy, int $noticeId) {
        return self::getClass()->send([
            "createBy" => $createBy,
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 待修改的信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdate (int $updateBy, array $data) {
        return self::getClass()->batchUpdate([
            "updateBy" => $updateBy,
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  int $updateBy 更新人工号 [ require true ]
     * @param  array $data 待关闭的信息 [ require true ]
     * @param  bool $check 是否校验预付款 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchClose (int $updateBy, array $data, bool $check = true) {
        return self::getClass()->batchClose([
            "updateBy" => $updateBy,
            "data" => $data,
            "check" => $check,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $orderItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByOrderItemIds (array $orderItemIds) {
        return self::getClass()->getItemsByOrderItemIds([
            "orderItemIds" => $orderItemIds,
        ]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $demandItemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByDemandItemIds (array $demandItemIds) {
        return self::getClass()->getItemsByDemandItemIds([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 根据订单明细ids获取发货明细信息
     *
     * @param  array $itemIds 采购单itemids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByItemIds (array $itemIds) {
        return self::getClass()->getItemsByItemIds([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 根据发货ids获取发货信息
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSearchCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO[]
     */
    public static function getByIds (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSearchCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getByIds($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO[]"
        );
    }


    /**
     * 根据发货ids获取发货信息
     *
     * @param  array $status status [ require true ]
     * @param  array $noticeIds noticeIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByStatusAndNoticeIds (array $status, array $noticeIds) {
        return self::getClass()->getItemsByStatusAndNoticeIds([
            "status" => $status,
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 根据发货单IDs获取明细
     *
     * @param  array $noticeIds 发货通知单IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemsByNoticeIds (array $noticeIds) {
        return self::getClass()->getItemsByNoticeIds([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 重试 推送ebs失败收货单
     *
     * @param  array $receiveIds 收货单ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function trySyncReceiveToWms (array $receiveIds) {
        return self::getClass()->trySyncReceiveToWms([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 查询发货通知单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO[]
     */
    public static function searchShipNotice (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeSearchCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchShipNotice($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\DTO\PurchaseShipNoticeDTO[]"
        );
    }


    /**
     * 发货通知单更改预计到货时间-发货时间
     *
     * @param  array $noticeIds 发货通知单id [ require true ]
     * @param  int $arriveDate 是否加急 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changePlanShipDate (array $noticeIds, int $arriveDate) {
        return self::getClass()->changePlanShipDate([
            "noticeIds" => $noticeIds,
            "arriveDate" => $arriveDate,
        ]);
    }

    /**
     * checkBmsShip
     *
     * @support  array $noticeIds 发货通知单ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkBmsShip () {
        return self::getClass()->checkBmsShip([
        ]);
    }

    /**
     * checkBmsNoticeItemIds
     *
     * @support  array $noticeItemIds 发货通知单子单ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkBmsNoticeItemIds () {
        return self::getClass()->checkBmsNoticeItemIds([
        ]);
    }

    /**
     * 批量发运接口更新,不合单。一个主单对应一个子单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSendCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function batchSendItems (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\ShipNoticeItemSendCMD $CMD) {
        return self::getClass()->batchSendItems($CMD);
    }


    /**
     * 获取同一个发货通知单仓库下红点数量
     *
     * @param  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getRedPointCountByStorageId (int $storageId) {
        return self::getClass()->getRedPointCountByStorageId([
            "storageId" => $storageId,
        ]);
    }

    /**
     * 查询供应商协同发货通知单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\SupplyShipNoticeItemSearchCMD $searchCMD
     * @throws  \Exception
     * @return  array
     */
    public static function searchSupplyShipNoticeItems (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\SupplyShipNoticeItemSearchCMD $searchCMD) {
        return self::getClass()->searchSupplyShipNoticeItems($searchCMD);
    }


    /**
     * 获取同一个发货通知单仓库下门店数
     *
     * @param  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShopCountByStorageId (int $storageId) {
        return self::getClass()->getShopCountByStorageId([
            "storageId" => $storageId,
        ]);
    }

    /**
     * 批量推送调拨单到wms
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\PushToWMSCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function pushToWms (\Mainto\Bridge\Structs\HimoSupplyChain\PurchaseShipNotice\CMD\PushToWMSCMD $CMD) {
        return self::getClass()->pushToWms($CMD);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}