<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addStorageExpressBlockByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $params)
 * @method searchStorageExpressBlockByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $params)
 * @method deleteStorageExpressBlockByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $params)
 */
class StorageExpressBlock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * addStorageExpressBlock
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\StorageExpressBlockDTO
     */
    public static function addStorageExpressBlock (\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addStorageExpressBlock($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\StorageExpressBlockDTO"
        );
    }


    /**
     * searchStorageExpressBlock
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\StorageExpressBlockDTO[]
     */
    public static function searchStorageExpressBlock (\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchStorageExpressBlock($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Predict\DTO\StorageExpressBlockDTO[]"
        );
    }


    /**
     * deleteStorageExpressBlock
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteStorageExpressBlock (\Mainto\Bridge\Structs\HimoSupplyChain\Predict\CMD\StorageExpressBlockCMD $CMD) {
        return self::getClass()->deleteStorageExpressBlock($CMD);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'StorageExpressBlock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'StorageExpressBlock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}