<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params)
 * @method getPageListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderPageListCmd $params)
 * @method detailByParams(array $params)
 * @method batchCreateByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderBatchCreateCmd $params)
 */
class ProcessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建加工单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\DTO\ProcessOrderCreateDTO
     */
    public static function create (\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($params),
            "\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\DTO\ProcessOrderCreateDTO"
        );
    }


    /**
     * 加工单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderPageListCmd $params
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\DTO\ProcessOrderPageListDTO
     */
    public static function getPageList (\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderPageListCmd $params) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPageList($params),
            "\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\DTO\ProcessOrderPageListDTO"
        );
    }


    /**
     * 加工单详情
     *
     * @param  int $id 加工单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 创建加工单
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderBatchCreateCmd $batchData
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreate (\Mainto\Bridge\Structs\HimoSupplyChain\ProcessOrder\Cmd\ProcessOrderBatchCreateCmd $batchData) {
        return self::getClass()->batchCreate($batchData);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ProcessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ProcessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}