<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allocationCountByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $params)
 * @method allocationCreateByListByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method itemListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $params)
 * @method allItemListByParams(array $params)
 * @method batchCreateByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationBatchCreateCMD $params)
 * @method supplierAllocationListByParams(array $params)
 * @method leftRemindByParams(array $params)
 * @method getSupplyAllocationListTagCountByParams(array $params)
 */
class Allocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取调拨单数量
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\CountDTO
     */
    public static function allocationCount (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationSearchCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->allocationCount($CMD),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\CountDTO"
        );
    }


    /**
     * 调拨单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD) {
        return self::getClass()->list($CMD);
    }


    /**
     * 调拨单创建人列表
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @support  array $allocationTypes 单据类型数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allocationCreateByList () {
        return self::getClass()->allocationCreateByList([
        ]);
    }

    /**
     * 获取调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO"
        );
    }

    /**
     * 获取调拨单号详情
     *
     * @param  string $allocationNo 调拨单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByNo (string $allocationNo) {
        return self::getClass()->detailByNo([
            "allocationNo" => $allocationNo,
        ]);
    }

    /**
     * 调拨单子单据列表--分页
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationItemPaginateSearchCMD $CMD) {
        return self::getClass()->itemList($CMD);
    }


    /**
     * 调拨单子单据列表--不分页
     *
     * @support  int $id 调拨单id [ require false ]
     * @support  array $ids 调拨单id列表 [ require false ]
     * @support  string $skuName sku名字 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @support  array $withInfo with关联的信息结构如：[&#039;sku&#039;,&#039;allocation&#039;] [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allItemList () {
        return self::getClass()->allItemList([
        ]);
    }

    /**
     * 批量创建调拨单,只保留这一个接口
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationBatchCreateCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]
     */
    public static function batchCreate (\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\CMD\AllocationBatchCreateCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->batchCreate($cmd),
            "\Mainto\Bridge\Structs\HimoSupplyChain\Allocation\DTO\AllocationDTO[]"
        );
    }


    /**
     * 协同平台调拨单
     *
     * @support  array $statusMap 状态 [ require false ]
     * @support  array $skuIds 物料ids [ require false ]
     * @support  int $skuId 物料id [ require false ]
     * @support  array $toStorageIds 收货方 [ require false ]
     * @support  string $planShipDateAtStart 预计发货时间 起 [ require false ]
     * @support  string $planShipDateAtEnd 预计发货时间 起 [ require false ]
     * @support  string $planLatestShipDateAtStart 最晚发货时间 起 [ require false ]
     * @support  string $planLatestShipDateAtEnd 最晚发货时间 终 [ require false ]
     * @support  string $startShipTimeStart 开始发货时间Start [ require false ]
     * @support  string $startShipTimeEnd 开始发货时间End [ require false ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @support  int $expedited 是否加急 [ require false ]
     * @support  int $supplierId 供应商id [ require true ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @support  array $sort 列表排序 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplierAllocationList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->supplierAllocationList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 协同供调拨单提醒
     *
     * @param  array $storageIds 协同供应商仓库ids [ require true ]
     * @param  array $statusMap 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function leftRemind (array $storageIds, array $statusMap) {
        return self::getClass()->leftRemind([
            "storageIds" => $storageIds,
            "statusMap" => $statusMap,
        ]);
    }

    /**
     * 调拨单标签数据
     *
     * @param  array $storageIds 协同供应商仓库ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyAllocationListTagCount (array $storageIds) {
        return self::getClass()->getSupplyAllocationListTagCount([
            "storageIds" => $storageIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}