<?php
namespace Mainto\Bridge\Enums\HimoSupplyChain;

class ExpressDeliveryStatusEnum {
    /**
     * 未订阅
     */
    const UN_SUBSCRIBE = 0;
    /**
     * 在途中
     */
    const ON_LINE = 1;
    /**
     * 派送中
     */
    const SENDING = 2;
    /**
     * 待取件
     */
    const WAIT_PICKUP = 3;
    /**
     * 已签收
     */
    const SIGNED = 4;
    /**
     * 异常
     */
    const WARN = 5;
    /**
     * 重推
     */
    const TRY_PUSH = 99;
    const EXPRESS_DELIVERY_STATUS_ALL = [0 => ['key' => 0,'value' => '未订阅'],1 => ['key' => 1,'value' => '在途中'],2 => ['key' => 2,'value' => '派送中'],3 => ['key' => 3,'value' => '待取件'],4 => ['key' => 4,'value' => '已签收'],5 => ['key' => 5,'value' => '异常'],6 => ['key' => 99,'value' => '重推']];
}