<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogisticDetailByNoByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Logistic\CMD\SearchLogisticCmd $params)
 */
class Logistic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物流单号详情
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Logistic\CMD\SearchLogisticCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogisticDetailByNo (\Mainto\Bridge\Structs\HimoSupplyChain\Logistic\CMD\SearchLogisticCmd $cmd) {
        return self::getClass()->getLogisticDetailByNo($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Logistic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Logistic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}