<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getFirstByParams(array $params)
 * @method delProductTagByParams(array $params)
 */
class ProductTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料标签列表(分页)
     *
     * @support  array $productTagIds 标签ids [ require false ]
     * @support  string $tagName 标签名（模糊查询 [ require false ]
     * @support  string $isShow 是否展示 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  int $created_by 创建人 [ require false ]
     * @support  string $updatedAtStart 更新时间（起） [ require false ]
     * @support  string $updatedAtEnd 更新时间（终） [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfo (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getInfo([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取产品标签列表
     *
     * @support  int $productTagId 标签id [ require false ]
     * @support  array $productTagIds 标签ids [ require false ]
     * @support  array $storeTypes 门店品牌类型组 [ require false ]
     * @support  string $tagName 标签名（模糊查询 [ require false ]
     * @support  string $isShow 是否展示 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  int $createdBy 创建人 [ require false ]
     * @support  string $updatedAtStart 创建人 [ require false ]
     * @support  string $updatedAtEnd 创建人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 创建物料标签
     *
     * @support  string $tagName 标签名（模糊查询 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  array $storeType 门店品牌 [ require false ]
     * @support  int $createdBy 创建人 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑物料标签
     *
     * @support  int $productTagId 标签ID [ require false ]
     * @support  string $tagName 标签名（模糊查询 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @support  string $isShow 是否展示 [ require false ]
     * @support  array $storeType 门店品牌 [ require false ]
     * @support  int $updatedBy 创建人 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 获取单个商品标签
     *
     * @support  int $productTagId 标签id [ require false ]
     * @support  array $productTagIds 标签ids [ require false ]
     * @support  string $tagName 标签名 [ require false ]
     * @support  string $storeType 门店品牌 [ require false ]
     * @support  string $type 标签类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFirst () {
        return self::getClass()->getFirst([
        ]);
    }

    /**
     * 删除标签
     *
     * @param  int $productTagId 标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delProductTag (int $productTagId) {
        return self::getClass()->delProductTag([
            "productTagId" => $productTagId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'ProductTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'ProductTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}