<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUnitsByParams(array $params)
 * @method syncUnitByParams(array $params)
 */
class Units {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取sku的数量单位信息
     *
     * @support  string $id id [ require false ]
     * @support  array $ids ids [ require false ]
     * @support  string $name 名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUnits () {
        return self::getClass()->getUnits([
        ]);
    }

    /**
     * 同步sku的数量单位信息
     *
     * @support  string $name 单位名称 [ require false ]
     * @support  int $nsId nsId [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncUnit () {
        return self::getClass()->syncUnit([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Units');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Units');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}