<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method logisticsCallBackByParams(array $params)
 * @method autoSetStockRedisByParams(array $params)
 * @method redisDelByParams(array $params)
 * @method redisGetByParams(array $params)
 * @method getEsStatusByParams(array $params)
 * @method createExpressTypeNameByParams(array $params)
 * @method cliByParams(array $params)
 * @method autoSendSmsByParams(array $params)
 * @method censusExceptionOrderByParams(array $params)
 * @method censusPurchaseOrderByParams(array $params)
 * @method rebuildCacheByParams(array $params)
 * @method setEsSetByParams(array $params)
 * @method setStockOutNameByParams(array $params)
 * @method setStockInNameByParams(array $params)
 * @method pushStockDiffByParams(array $params)
 * @method stockByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * logisticsCallBack
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function logisticsCallBack () {
        return self::getClass()->logisticsCallBack();
    }

    /**
     * 自动初始化每日库存map
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoSetStockRedis () {
        return self::getClass()->autoSetStockRedis();
    }

    /**
     * redis信息删除
     *
     * @support  string $type 操作类型 [ require true ]
     * @support  string $key key名称 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function redisDel () {
        return self::getClass()->redisDel([
        ]);
    }

    /**
     * redis信息读取
     *
     * @support  string $type 操作类型 [ require true ]
     * @support  string $key key名称 [ require false ]
     * @support  string $hskey hashkey名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function redisGet () {
        return self::getClass()->redisGet([
        ]);
    }

    /**
     * es信息读取
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getEsStatus (string $name) {
        return self::getClass()->getEsStatus([
            "name" => $name,
        ]);
    }

    /**
     * 创建新的快递类型
     *
     * @param  string $name 快递名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createExpressTypeName (string $name) {
        return self::getClass()->createExpressTypeName([
            "name" => $name,
        ]);
    }

    /**
     * 初始化单据状态
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cli () {
        return self::getClass()->cli();
    }

    /**
     * 初始化单据状态
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoSendSms () {
        return self::getClass()->autoSendSms();
    }

    /**
     * 异常工单提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function censusExceptionOrder () {
        return self::getClass()->censusExceptionOrder();
    }

    /**
     * 超期未处理订单提醒
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function censusPurchaseOrder () {
        return self::getClass()->censusPurchaseOrder();
    }

    /**
     * 增加重新建立Cache缓存接口
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function rebuildCache () {
        return self::getClass()->rebuildCache();
    }

    /**
     * 开启/关闭对应es查询
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $set 是否开启 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setEsSet (string $name, int $set) {
        return self::getClass()->setEsSet([
            "name" => $name,
            "set" => $set,
        ]);
    }

    /**
     * 设置出库单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStockOutName () {
        return self::getClass()->setStockOutName();
    }

    /**
     * 设置入库单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStockInName () {
        return self::getClass()->setStockInName();
    }

    /**
     * 异步钉钉推送
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushStockDiff () {
        return self::getClass()->pushStockDiff();
    }

    /**
     * 库存核对
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function stock () {
        return self::getClass()->stock();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}