<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method countByParams(array $params)
 * @method listByParams(array $params)
 * @method allocationCreateByListByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method itemListByParams(array $params)
 * @method allItemListByParams(array $params)
 * @method setAllocationNameByParams(array $params)
 * @method createByParams(array $params)
 * @method batchCreateByParams(array $params)
 * @method allocationShipByParams(array $params)
 * @method closeAllocationItemByParams(array $params)
 * @method closeAllocationByIdsByParams(array $params)
 * @method allocationsCancelToEbsByParams(array $params)
 * @method itemListByDemandItemIdsByParams(array $params)
 * @method allocationsRetryToEbsByParams(array $params)
 * @method allocationPushToWmsByParams(array $params)
 * @method receiveRetryToEbsByParams(array $params)
 * @method checkCloseAllocationByIdsByParams(array $params)
 * @method changePlanShipDateByParams(array $params)
 * @method bmsNotOperableStoragesByParams(array $params)
 * @method supplierAllocationListByParams(array $params)
 * @method getLogisticByParams(array $params)
 * @method leftRemindByParams(array $params)
 * @method getSupplyAllocationListTagCountByParams(array $params)
 * @method getSupplyStorageByParams(array $params)
 */
class Allocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取调拨单数量
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require false ]
     * @support  string $allocationType 单据类型 [ require false ]
     * @support  array $allocationTypes 单据类型数组 [ require false ]
     * @support  int $fromStorageId 发货仓库id [ require false ]
     * @support  int $toStorageId 收货仓库id [ require false ]
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count([
        ]);
    }

    /**
     * 调拨单列表
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require false ]
     * @support  string $createdAtStart 创建时间开始 [ require false ]
     * @support  string $createdAtEnd 创建时间结束 [ require false ]
     * @support  int $createBy 创建人id [ require false ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @support  string $allocationType 单据类型 [ require false ]
     * @support  array $allocationTypes 单据类型数组 [ require false ]
     * @support  int $fromStorageId 发货仓库id [ require false ]
     * @support  int $toStorageId 收货仓库id [ require false ]
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 [ require false ]
     * @support  string $skuName sku名称 [ require false ]
     * @support  array $relatedItemIds 需求单ids [ require false ]
     * @support  string $planDateEnd 预计发货时间 [ require false ]
     * @support  string $planDateStart 预计发货时间 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @param  int $searchAfter 当前页面的最大id [ require false ]
     * @param  int $useEs 是否使用新的es查询 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10, int $searchAfter = 0, int $useEs = 0) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "searchAfter" => $searchAfter,
            "useEs" => $useEs,
        ]);
    }

    /**
     * 调拨单创建人列表
     *
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @support  array $allocationTypes 单据类型数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allocationCreateByList () {
        return self::getClass()->allocationCreateByList([
        ]);
    }

    /**
     * 获取调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取调拨单号详情
     *
     * @param  string $allocationNo 调拨单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByNo (string $allocationNo) {
        return self::getClass()->detailByNo([
            "allocationNo" => $allocationNo,
        ]);
    }

    /**
     * 调拨单子单据列表--分页
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 调拨单子单据列表--不分页
     *
     * @support  int $id 调拨单id [ require false ]
     * @support  array $ids 调拨单id列表 [ require false ]
     * @support  string $skuName sku名字 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @support  array $withInfo with关联的信息结构如：[&#039;sku&#039;,&#039;allocation&#039;] [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allItemList () {
        return self::getClass()->allItemList([
        ]);
    }

    /**
     * 设置调拨单随机数key(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAllocationName () {
        return self::getClass()->setAllocationName();
    }

    /**
     * 创建调拨单
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationType 单据类型 [ require true ]
     * @support  int $fromStoreId 出仓门店id [ require false ]
     * @support  int $fromStorageId 出货仓库id [ require false ]
     * @support  int $toStoreId 收货门店id [ require false ]
     * @support  int $toStorageId 收货仓库id [ require false ]
     * @support  array $itemList 调拨单sku列表 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @param  int $operateId 操作人ID [ require true ]
     * @support  int $receiveLogId 收货地址id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量创建调拨单
     *
     * @param  array $data 批量调拨列表，单节点参照单条创建 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (array $data, int $operateId) {
        return self::getClass()->batchCreate([
            "data" => $data,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  string $operateType 操作平台类型 [ require true ]
     * @support  int $fromStaffId 发货人id [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function allocationShip (int $operateId, string $operateType = 'internal') {
        return self::getClass()->allocationShip([
            "operateId" => $operateId,
            "operateType" => $operateType,
        ]);
    }

    /**
     * 关闭调拨单
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeAllocationItem (int $operateId) {
        return self::getClass()->closeAllocationItem([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量关闭调拨单
     *
     * @support  array $ids 调拨单ids [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  string $remark 备注 [ require false ]
     * @param  bool $isCheck 备注 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function closeAllocationByIds (int $operateId, string $remark = '', bool $isCheck = false) {
        return self::getClass()->closeAllocationByIds([
            "operateId" => $operateId,
            "remark" => $remark,
            "isCheck" => $isCheck,
        ]);
    }

    /**
     * 重试 通过ebs批量关闭wms调拨单
     *
     * @param  array $allocationNos 调拨单号allocationNos [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function allocationsCancelToEbs (array $allocationNos) {
        return self::getClass()->allocationsCancelToEbs([
            "allocationNos" => $allocationNos,
        ]);
    }

    /**
     * 根据需求明细IDs获取调拨明细
     *
     * @param  array $demandItemIds 需求itemIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemListByDemandItemIds (array $demandItemIds) {
        return self::getClass()->itemListByDemandItemIds([
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 重试 推送ebs失败的调拨单
     *
     * @param  array $allocationNos 调拨单号allocationNos [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allocationsRetryToEbs (array $allocationNos) {
        return self::getClass()->allocationsRetryToEbs([
            "allocationNos" => $allocationNos,
        ]);
    }

    /**
     * 批量推送调拨单到wms
     *
     * @param  array $allocationIds 要推送的调拨id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function allocationPushToWms (array $allocationIds) {
        return self::getClass()->allocationPushToWms([
            "allocationIds" => $allocationIds,
        ]);
    }

    /**
     * 重试 推送ebs失败的调拨单-入仓
     *
     * @param  array $receiveIds 收货单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveRetryToEbs (array $receiveIds) {
        return self::getClass()->receiveRetryToEbs([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 通过传入 ids 查看调拨单能否被全部关闭
     *
     * @param  array $ids 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkCloseAllocationByIds (array $ids) {
        return self::getClass()->checkCloseAllocationByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 加急调拨单
     *
     * @param  array $allocationIds 调拨单ids [ require true ]
     * @param  int $expedited 是否加急 [ require false ]
     * @param  string $planShipDate 预计发货时间 [ require false ]
     * @param  string $planLastShipDate 最晚发货时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changePlanShipDate (array $allocationIds, int $expedited = 0, string $planShipDate = '', string $planLastShipDate = '') {
        return self::getClass()->changePlanShipDate([
            "allocationIds" => $allocationIds,
            "expedited" => $expedited,
            "planShipDate" => $planShipDate,
            "planLastShipDate" => $planLastShipDate,
        ]);
    }

    /**
     * 获取bms不可以操作的仓库
     *
     * @throws  \Exception
     * @return  array
     */
    public static function bmsNotOperableStorages () {
        return self::getClass()->bmsNotOperableStorages();
    }

    /**
     * 协同平台调拨单
     *
     * @support  array $statusMap 状态 [ require false ]
     * @support  array $skuIds 物料ids [ require false ]
     * @support  int $skuId 物料id [ require false ]
     * @support  array $toStorageIds 收货方 [ require false ]
     * @support  string $planShipDateAtStart 预计发货时间 起 [ require false ]
     * @support  string $planShipDateAtEnd 预计发货时间 起 [ require false ]
     * @support  string $planLatestShipDateAtStart 最晚发货时间 起 [ require false ]
     * @support  string $planLatestShipDateAtEnd 最晚发货时间 终 [ require false ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @support  int $expedited 是否加急 [ require false ]
     * @support  int $supplierId 供应商id [ require true ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @support  array $sort 列表排序 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplierAllocationList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->supplierAllocationList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取调拨单子单关联单号
     *
     * @param  array $itemIds 物料id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogistic (array $itemIds) {
        return self::getClass()->getLogistic([
            "itemIds" => $itemIds,
        ]);
    }

    /**
     * 协同供调拨单提醒
     *
     * @param  array $storageIds 协同供应商仓库ids [ require true ]
     * @param  array $statusMap 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function leftRemind (array $storageIds, array $statusMap) {
        return self::getClass()->leftRemind([
            "storageIds" => $storageIds,
            "statusMap" => $statusMap,
        ]);
    }

    /**
     * 调拨单标签数据
     *
     * @param  array $storageIds 协同供应商仓库ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyAllocationListTagCount (array $storageIds) {
        return self::getClass()->getSupplyAllocationListTagCount([
            "storageIds" => $storageIds,
        ]);
    }

    /**
     * 协同供应商仓库id
     *
     * @param  int $supplierId 协同供应商id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSupplyStorage (int $supplierId) {
        return self::getClass()->getSupplyStorage([
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}