<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductSkuTransformByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\Base\CMD\IdsCmd $params)
 * @method getProductSkuPageListByParams(array|\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\ProductSkuPageListCmd $params)
 * @method getRawSkuListByParams(array $params)
 */
class TransformInfo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取成品下的半成品配方
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\Base\CMD\IdsCmd $productSkuIds
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuTransform (\Mainto\Bridge\Structs\HimoSupplyChain\Base\CMD\IdsCmd $productSkuIds) {
        return self::getClass()->getProductSkuTransform($productSkuIds);
    }


    /**
     * 成品boom
     *
     * @var  \Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\ProductSkuPageListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\DTO\ProductSkuPageListDTO
     */
    public static function getProductSkuPageList (\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\Cmd\ProductSkuPageListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProductSkuPageList($cmd),
            "\Mainto\Bridge\Structs\HimoSupplyChain\MaterialSku\DTO\ProductSkuPageListDTO"
        );
    }


    /**
     * 通过半成品查询配方
     *
     * @support  int $rawSkuId 半成品Id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRawSkuList () {
        return self::getClass()->getRawSkuList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'TransformInfo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'TransformInfo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}