<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchDealByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method itemListByParams(array $params)
 */
class PurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量处理
     *
     * @param  int $createBy 创建人工号 [Original type uint] [ require true ]
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDeal (int $createBy, array $demandItemIds) {
        return self::getClass()->batchDeal([
            "createBy" => $createBy,
            "demandItemIds" => $demandItemIds,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @param  string $closeReason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose (int $updateBy, array $demandItemIds, string $closeReason) {
        return self::getClass()->batchClose([
            "updateBy" => $updateBy,
            "demandItemIds" => $demandItemIds,
            "closeReason" => $closeReason,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $createBy 创建人工号 [Original type uint] [ require true ]
     * @support  string $demandNo 需求单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  array $materialIds 物料id 
     * @support  array $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemList (int $createBy, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "createBy" => $createBy,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}