<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStorageByStoreIdByParams(array $params)
 * @method getStorageByIdByParams(array $params)
 * @method getStorageListByParams(array $params)
 * @method getStoragesByParams(array $params)
 */
class Storage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店仓库
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $source 仓库归属方 1是总部，2是门店，3是供应商 [ require true ]
     * @param  int $useType 仓库用途1是零售仓，2是自用仓 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreId (int $storeId, int $source, int $useType) {
        return self::getClass()->getStorageByStoreId([
            "storeId" => $storeId,
            "source" => $source,
            "useType" => $useType,
        ]);
    }

    /**
     * 根据id获取仓库信息
     *
     * @param  int $id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageById (int $id) {
        return self::getClass()->getStorageById([
            "id" => $id,
        ]);
    }

    /**
     * 获取门店仓库列表
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $source 仓库归属方 1是总部，2是门店，3是供应商 [ require true ]
     * @param  int $useType 仓库用途1是零售仓，2是自用仓 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageList (int $storeId, int $source, int $useType) {
        return self::getClass()->getStorageList([
            "storeId" => $storeId,
            "source" => $source,
            "useType" => $useType,
        ]);
    }

    /**
     * 获取门店仓库列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStorages () {
        return self::getClass()->getStorages();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Storage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Storage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}