<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateByParams(array $params)
 * @method revokeByParams(array $params)
 * @method submitByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method createByParams(array $params)
 */
class PurchaseDue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $dueNo 应付款单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @support  int $createBy 创建人工号 [Original type uint] 
     * @support  string $approveStatus 审批状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $dueId 应付款单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $dueId) {
        return self::getClass()->detail([
            "dueId" => $dueId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $dueId 应付款单id [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $dueId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "dueId" => $dueId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  int $dueId 应付款单id [Original type uint] [ require true ]
     * @support  int $supplierBankId 供应商账户id [Original type uint] 
     * @support  float $exceptTax 不含税金额 [Original type double] 
     * @support  float $tax 税额 [Original type double] 
     * @support  string $invoiceNumber 发票号 
     * @support  float $freight 运费 [Original type double] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $dueId, int $updateBy) {
        return self::getClass()->update([
            "dueId" => $dueId,
            "updateBy" => $updateBy,
        ]);
    }

    /**
     * 撤销审批
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  int $dueId 应付款单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revoke (int $updateBy, int $dueId) {
        return self::getClass()->revoke([
            "updateBy" => $updateBy,
            "dueId" => $dueId,
        ]);
    }

    /**
     * 提交审批
     *
     * @param  int $updateBy 更新人工号 [Original type uint] [ require true ]
     * @param  int $dueId 应付款单id [Original type uint] [ require true ]
     * @param  string $processInstanceId 审批id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $updateBy, int $dueId, string $processInstanceId) {
        return self::getClass()->submit([
            "updateBy" => $updateBy,
            "dueId" => $dueId,
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 创建应付账单
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @param  int $createBy 创建人工号 [Original type uint] [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] 
     * @support  array $items 关联物料 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $orderId, int $createBy) {
        return self::getClass()->create([
            "orderId" => $orderId,
            "createBy" => $createBy,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'PurchaseDue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'PurchaseDue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}