<?php
namespace Mainto\Bridge\Invokes\HimoSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method countByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method setAllocationNameByParams(array $params)
 * @method createByParams(array $params)
 * @method allocationShipByParams(array $params)
 */
class Allocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取调拨单数量
     *
     * @param  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @param  int $fromStorageId 发货仓库id [ require true ]
     * @param  int $toStorageId 收货仓库id [ require true ]
     * @param  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function count (int $createType, int $fromStorageId, int $toStorageId, array $status) {
        return self::getClass()->count([
            "createType" => $createType,
            "fromStorageId" => $fromStorageId,
            "toStorageId" => $toStorageId,
            "status" => $status,
        ]);
    }

    /**
     * 调拨单列表
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 
     * @support  string $allocationType 单据类型 
     * @support  int $fromStorageId 发货仓库id 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 
     * @support  string $skuName sku名称 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调拨单子单据列表
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 
     * @support  string $skuCode sku编码 
     * @param  int $page 当前页 [Original type uint] [ require true ]
     * @param  int $pageSize 页内条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 设置调拨单随机字符串(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAllocationName () {
        return self::getClass()->setAllocationName();
    }

    /**
     * 创建调拨单
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  int $allocationType 单据类型 [ require true ]
     * @support  int $fromStoreId 出仓门店id 
     * @support  int $fromStorageId 出货仓库id 
     * @support  int $toStoreId 收货门店id 
     * @support  int $toStorageId 收货仓库id 
     * @support  array $itemList 调拨单sku列表 
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 调拨单发货
     *
     * @param  int $id 调拨单id [ require true ]
     * @param  array $itemList 调拨单sku列表 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allocationShip (int $id, array $itemList, int $operateId) {
        return self::getClass()->allocationShip([
            "id" => $id,
            "itemList" => $itemList,
            "operateId" => $operateId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoSupplyChain', 'Allocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}