<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-11 11:44:49
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SellChannel
 */
class SellChannel {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "SellChannel";

    /**
     * 创建销售渠道
     *
     */
    public static function create (string $name, string $code, int $isStoreSell) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "code" => $code, "isStoreSell" => $isStoreSell, ]);
    }
    /**
     * 销售渠道列表
     *
     */
    public static function list (int $id, array $ids, string $code, array $codes, string $name, int $isStoreSell): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["id" => $id, "ids" => $ids, "code" => $code, "codes" => $codes, "name" => $name, "isStoreSell" => $isStoreSell, ]);
    }
    /**
     * 销售渠道创建productSku
     *
     */
    public static function createProductAndProductSku (\Mainto\Bridge\Structs\HimoRetailProduct\SellChannel\CreateProductAndProductSkuParamsContent $content): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createProductAndProductSku(["content" => $content, ]);
    }
    /**
     * 销售渠道productSku详情
     *
     */
    public static function productSkuDetail (int $sellChannelProductSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuDetail(["sellChannelProductSkuId" => $sellChannelProductSkuId, ]);
    }
    /**
     * 根据产品id获取产品和sku
     *
     */
    public static function productDetailWithSku (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDetailWithSku(["id" => $id, ]);
    }
    /**
     * 复制渠道商品sku
     *
     */
    public static function copyProductSku (int $sellChannelProductSkuId, string $sellChannelSkuName, string $sellChannelSkuImage, float $sellPrice, float $settlementPrice): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyProductSku(["sellChannelProductSkuId" => $sellChannelProductSkuId, "sellChannelSkuName" => $sellChannelSkuName, "sellChannelSkuImage" => $sellChannelSkuImage, "sellPrice" => $sellPrice, "settlementPrice" => $settlementPrice, ]);
    }
    /**
     * 销售渠道更新productSku
     *
     */
    public static function updateProductSku (int $sellChannelProductSkuId, string $sellChannelSkuName, string $sellChannelSkuImage, string $outSkuCode, float $sellPrice, float $settlementPrice, int $updateBy): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductSku(["sellChannelProductSkuId" => $sellChannelProductSkuId, "sellChannelSkuName" => $sellChannelSkuName, "sellChannelSkuImage" => $sellChannelSkuImage, "outSkuCode" => $outSkuCode, "sellPrice" => $sellPrice, "settlementPrice" => $settlementPrice, "updateBy" => $updateBy, ]);
    }
    /**
     * 销售渠道product列表
     *
     */
    public static function productList (array $ids, int $sellChannelId, int $type, array $categoryIds, string $productName, array $productIds, bool $isOnlyShelveUp) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productList(["ids" => $ids, "sellChannelId" => $sellChannelId, "type" => $type, "categoryIds" => $categoryIds, "productName" => $productName, "productIds" => $productIds, "isOnlyShelveUp" => $isOnlyShelveUp, ]);
    }
    /**
     * 获取渠道product，不包含sku信息列表
     *
     */
    public static function onlyProductList (array $ids, int $sellChannelId, int $type, array $categoryIds, string $productName, bool $isOnlyShelveUp) {
        return RpcClass::getClass(self::$serviceName, self::$className)->onlyProductList(["ids" => $ids, "sellChannelId" => $sellChannelId, "type" => $type, "categoryIds" => $categoryIds, "productName" => $productName, "isOnlyShelveUp" => $isOnlyShelveUp, ]);
    }
    /**
     * 批量销售渠道上架product
     *
     */
    public static function shelveProduct (array $sellChannelProductIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->shelveProduct(["sellChannelProductIds" => $sellChannelProductIds, ]);
    }
    /**
     * 批量销售渠道下架product
     *
     */
    public static function unShelveProduct (array $sellChannelProductIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->unShelveProduct(["sellChannelProductIds" => $sellChannelProductIds, ]);
    }
    /**
     * 销售渠道product列表 - 分页
     *
     */
    public static function productListWithPaginate (array $ids, int $sellChannelId, array $categoryIds, string $productName, string $status, int $type, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWithPaginate(["ids" => $ids, "sellChannelId" => $sellChannelId, "categoryIds" => $categoryIds, "productName" => $productName, "status" => $status, "type" => $type, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 搜索product列表 - 分页
     *
     */
    public static function searchProductListWithPaginate (string $productName, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchProductListWithPaginate(["productName" => $productName, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取渠道productSku列表
     *
     */
    public static function productSkuList (array $ids, array $productSkuIds, int $storeId, int $sellChannelId, array $categoryIds, string $skuName, string $skuCode, array $skuCodes, string $outSkuCode, array $outSkuCodes, bool $isOnlyShelveUp) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["ids" => $ids, "productSkuIds" => $productSkuIds, "storeId" => $storeId, "sellChannelId" => $sellChannelId, "categoryIds" => $categoryIds, "skuName" => $skuName, "skuCode" => $skuCode, "skuCodes" => $skuCodes, "outSkuCode" => $outSkuCode, "outSkuCodes" => $outSkuCodes, "isOnlyShelveUp" => $isOnlyShelveUp, ]);
    }
    /**
     * 通过typeId提取渠道产品sku列表
     *
     */
    public static function getSkuByType (int $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuByType(["type" => $type, ]);
    }
    /**
     * 销售渠道productSku列表 - 分页
     *
     */
    public static function productSkuListWithPaginate (array $ids, int $storeId, int $sellChannelId, array $sellChannelProductIds, array $categoryIds, string $skuName, string $skuCode, bool $isOnlyShelveUp, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuListWithPaginate(["ids" => $ids, "storeId" => $storeId, "sellChannelId" => $sellChannelId, "sellChannelProductIds" => $sellChannelProductIds, "categoryIds" => $categoryIds, "skuName" => $skuName, "skuCode" => $skuCode, "isOnlyShelveUp" => $isOnlyShelveUp, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 批量销售渠道上架productSku
     *
     */
    public static function shelveProductSku (array $sellChannelProductSkuIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->shelveProductSku(["sellChannelProductSkuIds" => $sellChannelProductSkuIds, ]);
    }
    /**
     * 根据产品id，仅获取product主要信息
     *
     */
    public static function getProductById (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductById(["id" => $id, ]);
    }
    /**
     * 根据产品id，仅获取product主要信息
     *
     */
    public static function getProductSkuByProductId (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuByProductId(["id" => $id, ]);
    }
    /**
     * 批量销售渠道下架productSku
     *
     */
    public static function unshelveProductSku (array $sellChannelProductSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unshelveProductSku(["sellChannelProductSkuIds" => $sellChannelProductSkuIds, ]);
    }
    /**
     * 根据门店id和渠道skuIds获取对应的库存
     *
     */
    public static function getStockByStoreIdAndSkuIds (int $storeId, array $skuIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockByStoreIdAndSkuIds(["storeId" => $storeId, "skuIds" => $skuIds, ]);
    }
    /**
     * 根据渠道skuId获取在售卖的门店ids
     *
     */
    public static function getStoreIdsBySellChannelSkuId (int $skuId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsBySellChannelSkuId(["skuId" => $skuId, ]);
    }
    /**
     * 根据渠道skuIds获取在售卖的门店ids
     *
     */
    public static function getStoreIdsBySellChannelSkuIds (array $skuIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsBySellChannelSkuIds(["skuIds" => $skuIds, ]);
    }
    /**
     * 更新渠道spu数据
     *
     */
    public static function updateProduct (int $sellChannelProductId, string $name, array $newMainImage, array $bannerUrl, array $descriptionUrl, string $status, int $updateBy): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProduct(["sellChannelProductId" => $sellChannelProductId, "name" => $name, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "status" => $status, "updateBy" => $updateBy, ]);
    }
    /**
     * 批量设置productSku的sellPrice
     *
     */
    public static function batchUpdateProductSkuSellPrice (array $productSkus, int $updateBy): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateProductSkuSellPrice(["productSkus" => $productSkus, "updateBy" => $updateBy, ]);
    }
    /**
     * 批量设置productSku的sellPrice
     *
     */
    public static function batchUpdateSkuImageBySkuIds (array $updateProductSkuImages, int $updateBy): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuImageBySkuIds(["updateProductSkuImages" => $updateProductSkuImages, "updateBy" => $updateBy, ]);
    }
    /**
     * 批量设置赠品Sku
     *
     */
    public static function batchUpdateGiftProductSku (array $skuIds, int $discountId, string $startTime, string $endTime, array $storeIds, int $updateBy): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateGiftProductSku(["skuIds" => $skuIds, "discountId" => $discountId, "startTime" => $startTime, "endTime" => $endTime, "storeIds" => $storeIds, "updateBy" => $updateBy, ]);
    }
    /**
     * 获取某渠道下所有的skuIds-不分页
     *
     */
    public static function getProductSkuIdsBySellChannelId (int $sellChannelId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuIdsBySellChannelId(["sellChannelId" => $sellChannelId, ]);
    }
    /**
     * autoUpdateGiftProductSku
     *
     */
    public static function autoUpdateGiftProductSku (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoUpdateGiftProductSku();
    }
    /**
     * 通过渠道productSkuIds获取主商品维度sku和渠道-维度sku
     *
     */
    public static function getProductSkusBySkuIds (array $productSkuIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkusBySkuIds(["productSkuIds" => $productSkuIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}