<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-11 11:44:49
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Promotion
 */
class Promotion {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Promotion";

    /**
     * 创建促销活动
     *
     */
    public static function create (string $code, string $name, string $description, string $cover, string $type, string $assetUrl, int $offlinePromotions, int $onlinePromotions, int $offerOverlay, string $startedAt, string $endedAt, array $storeGroup, array $skuIds, array $rules, array $giveawaySkuIds, int $operateId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["code" => $code, "name" => $name, "description" => $description, "cover" => $cover, "type" => $type, "assetUrl" => $assetUrl, "offlinePromotions" => $offlinePromotions, "onlinePromotions" => $onlinePromotions, "offerOverlay" => $offerOverlay, "startedAt" => $startedAt, "endedAt" => $endedAt, "storeGroup" => $storeGroup, "skuIds" => $skuIds, "rules" => $rules, "giveawaySkuIds" => $giveawaySkuIds, "operateId" => $operateId, ]);
    }
    /**
     * 修改促销活动
     *
     */
    public static function update (int $id, string $name, string $code, string $description, string $cover, string $assetUrl, int $offlinePromotions, int $onlinePromotions, string $startedAt, string $endedAt, array $storeGroup, array $skuIds, array $giveawaySkuIds, int $operateId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "code" => $code, "description" => $description, "cover" => $cover, "assetUrl" => $assetUrl, "offlinePromotions" => $offlinePromotions, "onlinePromotions" => $onlinePromotions, "startedAt" => $startedAt, "endedAt" => $endedAt, "storeGroup" => $storeGroup, "skuIds" => $skuIds, "giveawaySkuIds" => $giveawaySkuIds, "operateId" => $operateId, ]);
    }
    /**
     * 修改促销活动时间
     *
     */
    public static function updateDate (int $id, string $startedAt, string $endedAt, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateDate(["id" => $id, "startedAt" => $startedAt, "endedAt" => $endedAt, "operateId" => $operateId, ]);
    }
    /**
     * 添加促销活动的的sku
     *
     */
    public static function addPromotionSku (int $id, array $skuIds, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPromotionSku(["id" => $id, "skuIds" => $skuIds, "operateId" => $operateId, ]);
    }
    /**
     * 删除促销活动的sku
     *
     */
    public static function removePromotionSku (int $id, array $skuIds, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->removePromotionSku(["id" => $id, "skuIds" => $skuIds, "operateId" => $operateId, ]);
    }
    /**
     * 添加促销活动的买赠商品
     *
     */
    public static function addPromotionGiveawaySku (int $id, array $giveawaySkuIds, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPromotionGiveawaySku(["id" => $id, "giveawaySkuIds" => $giveawaySkuIds, "operateId" => $operateId, ]);
    }
    /**
     * 删除促销活动的买赠商品
     *
     */
    public static function removePromotionGiveawaySku (int $id, array $giveawaySkuIds, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->removePromotionGiveawaySku(["id" => $id, "giveawaySkuIds" => $giveawaySkuIds, "operateId" => $operateId, ]);
    }
    /**
     * 结束促销活动
     *
     */
    public static function finishPromotion (int $id, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishPromotion(["id" => $id, "operateId" => $operateId, ]);
    }
    /**
     * 获取促销活动列表
     *
     */
    public static function list (string $name, string $status, string $type, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "status" => $status, "type" => $type, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取促销活动详情
     *
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 删除促销活动
     *
     */
    public static function remove (int $id, int $operateId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, "operateId" => $operateId, ]);
    }
    /**
     * onTimeChangeStatus
     *
     */
    public static function onTimeChangeStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->onTimeChangeStatus();
    }
    /**
     * 查询零售商品列表
     *
     */
    public static function getProductSkuList (string $type, int $categoryId, string $name, string $skuType, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuList(["type" => $type, "categoryId" => $categoryId, "name" => $name, "skuType" => $skuType, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 查询零售渠道productSku列表
     *
     */
    public static function productSkuList (string $type, array $categoryIds, string $skuName, bool $isOnlyShelveUp, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["type" => $type, "categoryIds" => $categoryIds, "skuName" => $skuName, "isOnlyShelveUp" => $isOnlyShelveUp, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取促销活动的商品
     *
     */
    public static function getPromotionProductSku (int $promotionId, string $skuName, int $isGiveaway, string $status, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPromotionProductSku(["promotionId" => $promotionId, "skuName" => $skuName, "isGiveaway" => $isGiveaway, "status" => $status, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 根据店铺和skuIds获取sku相关的促销信息
     *
     */
    public static function getSkuPromotionListByStore (int $storeId, array $skuIds, int $offlinePromotions, int $onlinePromotions): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuPromotionListByStore(["storeId" => $storeId, "skuIds" => $skuIds, "offlinePromotions" => $offlinePromotions, "onlinePromotions" => $onlinePromotions, ]);
    }
    /**
     * 根据分类获取所有相关的零售商品
     *
     */
    public static function getAllProductSkuByCategory (string $type, int $categoryId, string $skuType): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductSkuByCategory(["type" => $type, "categoryId" => $categoryId, "skuType" => $skuType, ]);
    }
    /**
     * 批量添加促销活动的sku
     *
     */
    public static function batchAddPromotionSku (array $promotionSkuInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAddPromotionSku(["promotionSkuInfo" => $promotionSkuInfo, ]);
    }
    /**
     * 批量添加促销的买赠商品
     *
     */
    public static function batchAddPromotionGiveawaySku (array $promotionGiveawaySkuInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAddPromotionGiveawaySku(["promotionGiveawaySkuInfo" => $promotionGiveawaySkuInfo, ]);
    }
    /**
     * 根据skuIds获取sku相关的促销信息
     *
     */
    public static function getSkuPromotionListBySkuIds (array $skuIds, int $isGiveaway, int $offlinePromotions, int $onlinePromotions): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuPromotionListBySkuIds(["skuIds" => $skuIds, "isGiveaway" => $isGiveaway, "offlinePromotions" => $offlinePromotions, "onlinePromotions" => $onlinePromotions, ]);
    }
    /**
     * 获取所有促销活动
     *
     */
    public static function allPromotion (array $ids, string $name, string $status, string $type): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->allPromotion(["ids" => $ids, "name" => $name, "status" => $status, "type" => $type, ]);
    }
    /**
     * 批量删除促销活动的sku
     *
     */
    public static function batchRemovePromotionSku (array $promotionSkuInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchRemovePromotionSku(["promotionSkuInfo" => $promotionSkuInfo, ]);
    }
    /**
     * 批量删除促销的买赠商品
     *
     */
    public static function batchRemovePromotionGiveawaySku (array $promotionGiveawaySkuInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchRemovePromotionGiveawaySku(["promotionGiveawaySkuInfo" => $promotionGiveawaySkuInfo, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}