<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-11 11:44:49
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Project
 */
class Project {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Project";

    /**
     * 新增收集计划
     *
     */
    public static function create (string $name, string $project_start, string $project_end, string $description, array $sku_info, int $creator): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "project_start" => $project_start, "project_end" => $project_end, "description" => $description, "sku_info" => $sku_info, "creator" => $creator, ]);
    }
    /**
     * 计划列表
     *
     */
    public static function list (string $name, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 返回导入的SKU信息
     *
     */
    public static function productImport (array $skuIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productImport(["skuIds" => $skuIds, ]);
    }
    /**
     * 计划终止
     *
     */
    public static function terminate (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->terminate(["id" => $id, ]);
    }
    /**
     * 计划详情
     *
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 计划状态更新
     *
     */
    public static function updateState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateState();
    }
    /**
     * 计划包含的SKU
     *
     */
    public static function getSkuList (int $project_id, string $skuName, int $categoryId, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuList(["project_id" => $project_id, "skuName" => $skuName, "categoryId" => $categoryId, "page" => $page, "pageSize" => $pageSize, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}