<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSkuThemeListByParams(array $params)
 * @method getThemeTemplateDetailByParams(array $params)
 * @method getAddPageSkuAndTemplateByParams(array $params)
 * @method getSkuTemplateWorkDetailByParams(array $params)
 * @method getSkusTemplateTypeByParams(array $params)
 * @method productSkuBindServiceListByParams(array $params)
 * @method getSkuInitPageNumByParams(array $params)
 */
class CustomizedV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品sku下所有主题数据
     *
     * @param  int $skuId 产品skuId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuThemeListDTO[]
     */
    public static function getSkuThemeList (int $skuId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSkuThemeList([
                            "skuId" => $skuId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuThemeListDTO[]"
        );
    }

    /**
     * 获取sku的主题详情信息
     *
     * @support  int $skuId 产品skuId [ require true ]
     * @support  int $themeId 产品主题Id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuThemeTemplateDetailDTO
     */
    public static function getThemeTemplateDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getThemeTemplateDetail([
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuThemeTemplateDetailDTO"
        );
    }

    /**
     * 获取sku的加页增值服务，带增页模版信息
     *
     * @param  int $skuId 产品skuId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetAddPageSkuAndTemplateDTO
     */
    public static function getAddPageSkuAndTemplate (int $skuId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAddPageSkuAndTemplate([
                            "skuId" => $skuId,
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetAddPageSkuAndTemplateDTO"
        );
    }

    /**
     * 获取当前sku模版和增值服务、贴图、背景数据信息
     *
     * @support  int $skuId 产品skuId [ require true ]
     * @support  int $themeId 主题Id [ require false ]
     * @support  string $templateType 模版类型；书册封面：book_cover；相框类：photo_frame；书册内页：book_inner_page；书册logo页：book_logo_page；冲印：print_template； [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetSkuTemplateWorkDetailDTO
     */
    public static function getSkuTemplateWorkDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSkuTemplateWorkDetail([
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetSkuTemplateWorkDetailDTO"
        );
    }

    /**
     * 获取当前sku模版和增值服务、贴图、背景数据信息
     *
     * @support  array $skuIds 产品skuIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusTemplateType () {
        return self::getClass()->getSkusTemplateType([
        ]);
    }

    /**
     * 基础sku和增值服务绑定关系列表
     *
     * @support  array $productSkuIds 主商品维度productSkuId数组 [ require false ]
     * @support  array $serviceProductSkuIds 主商品维度增值服务的productSkuId数组 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ProductSkuBindServiceListDTO[]
     */
    public static function productSkuBindServiceList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productSkuBindServiceList([
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ProductSkuBindServiceListDTO[]"
        );
    }

    /**
     * 基础sku和增值服务绑定关系列表
     *
     * @support  int $productSkuId 渠道商品productSkuId [ require false ]
     * @support  string $templateType sku模版类型 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function getSkuInitPageNum () {
        return self::getClass()->getSkuInitPageNum([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Customized\CustomizedV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Customized\CustomizedV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}