<?php
namespace Mainto\Bridge\Enums\HimoRetailProduct;

class OperateEventTitleEnum {
    /**
     * 创建分类
     */
    const CATEGORY_CREATE = 'retail_product.category_create.event';
    /**
     * 更新分类
     */
    const CATEGORY_UPDATE = 'retail_product.category_update.event';
    /**
     * 删除分类
     */
    const CATEGORY_REMOVE = 'retail_product.category_remove.event';
    /**
     * 批量删除分类
     */
    const CATEGORY_BATCH_REMOVE = 'retail_product.category_batch_remove.event';
    /**
     * 批量删除分类
     */
    const CATEGORY_BATCH_UPDATE = 'retail_product.category_batch_update.event';
    /**
     * 添加商品
     */
    const PRODUCT_CREATE = 'retail_product.product_create.event';
    /**
     * 添加商品
     */
    const PRODUCT_UPDATE = 'retail_product.product_update.event';
    /**
     * 删除商品
     */
    const PRODUCT_REMOVE = 'retail_product.product_remove.event';
    /**
     * 上架商品
     */
    const PRODUCT_UP = 'retail_product.product_up.event';
    /**
     * 下架商品
     */
    const PRODUCT_OFF = 'retail_product.product_off.event';
    /**
     * 创建商品别名
     */
    const SKU_ALIAS_CREATE = 'retail_product.sku_alias_create.event';
    /**
     * 更新商品别名
     */
    const SKU_ALIAS_UPDATE = 'retail_product.sku_alias_update.event';
    /**
     * 商品别名绑定商品
     */
    const SKU_ALIAS_BINDING_PRODUCT = 'retail_product.sku_alias_binding_product.event';
    /**
     * 删除商品别名
     */
    const SKU_ALIAS_REMOVE = 'retail_product.sku_alias_remove.event';
    /**
     * 创建物料编码
     */
    const SKU_MATERIAL_CREATE = 'retail_product.sku_material_create.event';
    /**
     * 创建物料编码
     */
    const SKU_MATERIAL_UPDATE = 'retail_product.sku_material_update.event';
    /**
     * 删除物料编码
     */
    const SKU_MATERIAL_REMOVE = 'retail_product.sku_material_remove.event';
    /**
     * 关联物料编码
     */
    const SKU_MATERIAL_BINDING_SKU = 'retail_product.sku_material_binding_sku.event';
    /**
     * 创建店铺分组
     */
    const STORE_GROUP_CREATE = 'retail_product.store_group_create.event';
    /**
     * 更新店铺分组
     */
    const STORE_GROUP_UPDATE = 'retail_product.store_group_update.event';
    /**
     * 删除店铺分组
     */
    const STORE_GROUP_REMOVE = 'retail_product.store_group_remove.event';
    /**
     * 通过产品id删除门店信息
     */
    const STORE_DELETE_BY_PRODUCT_ID = 'retail_product.delete_store_by_product_id.event';
    /**
     * 通过产品id清空门店，门店组相关信息
     */
    const CLEAR_STORE_BY_PRODUCT_ID = 'retail_product.clear_store_by_product_id.event';
    /**
     * 绑定店铺
     */
    const STORE_GROUP_BINDING_STORE = 'retail_product.store_group_bing_store.event';
    /**
     * 创建促销活动
     */
    const PROMOTION_CREATE = 'retail_product.promotion_create.event';
    /**
     * 修改促销活动
     */
    const PROMOTION_UPDATE = 'retail_product.promotion_update.event';
    /**
     * 修改促销活动时间
     */
    const PROMOTION_UPDATE_DATE = 'retail_product.promotion_update_date.event';
    /**
     * 促销活动添加sku
     */
    const PROMOTION_ADD_SKU = 'retail_product.promotion_add_sku.event';
    /**
     * 促销活动删除sku
     */
    const PROMOTION_REMOVE_SKU = 'retail_product.promotion_remove_sku.event';
    /**
     * 促销活动添加买赠sku
     */
    const PROMOTION_ADD_GIVEAWAY_SKU = 'retail_product.promotion_add_giveaway_sku.event';
    /**
     * 促销活动删除买赠sku
     */
    const PROMOTION_REMOVE_GIVEAWAY_SKU = 'retail_product.promotion_remove_giveaway_sku.event';
    /**
     * 手动结束促销活动
     */
    const PROMOTION_FINISH = 'retail_product.promotion_finish.event';
    /**
     * 删除促销活动
     */
    const PROMOTION_REMOVE = 'retail_product.promotion_remove.event';
    /**
     * 删除发货单信息
     */
    const STORE_SHIP_REMOVE = 'retail_product.store_ship_remove.event';
    /**
     * 手动设置发货商品完成收货
     */
    const STORE_SHIP_PRODUCT_SET_FINISHED = 'retail_product.store_ship_product_set_finished.event';
    /**
     * 手动取消发货商品完成收货
     */
    const STORE_SHIP_PRODUCT_CANCEL_FINISHED = 'retail_product.store_ship_product_cancel_finished.event';
    /**
     * 手动设置发货完成
     */
    const STORE_SHIP_SET_FINISHED = 'retail_product.store_ship_set_finished.event';
    /**
     * 手动设置发货等待状态
     */
    const STORE_SHIP_SET_WAITING = 'retail_product.store_ship_set_waiting.event';
    /**
     * 手动设置发货部分发货状态
     */
    const STORE_SHIP_SET_PROCESSING = 'retail_product.store_ship_set_processing.event';
    /**
     * 撤销收货数据
     */
    const STORE_RECEIPT_PRODUCT_REPEAL = 'retail_product.store_receipt_product_repeal.event';
}