<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-07 13:49:28
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProjectCollect
 */
class ProjectCollect {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "ProjectCollect";

    /**
     * 门店收集状态
     * @return  array
    */
    public static function getState (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getState(["storeId" => $storeId]);
    }
    /**
     * 门店填写收集
     * @return  mixed
    */
    public static function save (int $project_id, array $sku_info, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->save(["project_id" => $project_id, "sku_info" => $sku_info, "store_id" => $store_id]);
    }
    /**
     * 门店历史信息收集
     * @return  mixed
    */
    public static function history (int $page = 1, int $pageSize = 20, int $store_id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->history(["page" => $page, "pageSize" => $pageSize, "store_id" => $store_id, "name" => $name]);
    }
    /**
     * 计划包含的SKU
     * @return  mixed
    */
    public static function getSkuList (int $page = 1, int $pageSize = 20, int $store_id, int $project_id, string $skuName, int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuList(["page" => $page, "pageSize" => $pageSize, "store_id" => $store_id, "project_id" => $project_id, "skuName" => $skuName, "categoryId" => $categoryId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}