<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-07 13:49:28
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductV2
 */
class ProductV2 {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "ProductV2";

    /**
     * setProductSkuTaskName
     * @return  mixed
    */
    public static function setProductSkuTaskName () {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductSkuTaskName();
    }
    /**
     * 创建产品
     * @return  mixed
    */
    public static function create (int $type, int $categoryId, int $isCombine, string $name, int $brandId, array $newMainImage, array $bannerUrl, array $descriptionUrl, int $needCheckStock = 0, array $categoryAttrs, int $createBy, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["type" => $type, "categoryId" => $categoryId, "isCombine" => $isCombine, "name" => $name, "brandId" => $brandId, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "needCheckStock" => $needCheckStock, "categoryAttrs" => $categoryAttrs, "createBy" => $createBy, "updateBy" => $updateBy]);
    }
    /**
     * 创建增值服务产品
     * @return  mixed
    */
    public static function createAddedProduct (int $type = 6, int $categoryId, string $name, int $createBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createAddedProduct(["type" => $type, "categoryId" => $categoryId, "name" => $name, "createBy" => $createBy]);
    }
    /**
     * 创建增值服务产品
     * @return  bool
    */
    public static function updateAddedProduct (int $id, int $type = 6, int $categoryId, string $name, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateAddedProduct(["id" => $id, "type" => $type, "categoryId" => $categoryId, "name" => $name, "updateBy" => $updateBy]);
    }
    /**
     * 创建/更新增值服务产品Sku
     * @return  bool
    */
    public static function addedProductSkuBatchUpdate (int $productId, array $productSku, int $createBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addedProductSkuBatchUpdate(["productId" => $productId, "productSku" => $productSku, "createBy" => $createBy]);
    }
    /**
     * 更新产品
     * @return  bool
    */
    public static function update (int $id, int $isCombine, int $type, int $categoryId, int $groupId, string $name, int $brandId, array $newMainImage, array $bannerUrl, array $descriptionUrl, bool $needCheckStock, array $categoryAttrs, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "isCombine" => $isCombine, "type" => $type, "categoryId" => $categoryId, "groupId" => $groupId, "name" => $name, "brandId" => $brandId, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "needCheckStock" => $needCheckStock, "categoryAttrs" => $categoryAttrs, "updateBy" => $updateBy]);
    }
    /**
     * 删除productSku
     * @return  bool
    */
    public static function productSkuDelete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuDelete(["id" => $id]);
    }
    /**
     * 上架productSku
     * @return  bool
    */
    public static function productSkuShelve (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuShelve(["id" => $id]);
    }
    /**
     * 下架productSku
     * @return  bool
    */
    public static function productSkuUnshelve (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuUnshelve(["id" => $id]);
    }
    /**
     * 上架product
     * @return  bool
    */
    public static function productUp (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productUp(["id" => $id]);
    }
    /**
     * 下架product
     * @return  bool
    */
    public static function productOff (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOff(["id" => $id]);
    }
    /**
     * 产品详情-不带productSku
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 产品详情-附带productSku
     * @return  array
    */
    public static function detailWithSku (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailWithSku(["id" => $id]);
    }
    /**
     * 根据产品id，仅获取product主要信息
     * @return  array
    */
    public static function getProductById (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductById(["id" => $id]);
    }
    /**
     * 根据产品productId，仅获取productSku主要信息
     * @return  array
    */
    public static function getProductSkuByProductId (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuByProductId(["productId" => $productId]);
    }
    /**
     * 获取productSku-分页
     * @return  array
    */
    public static function productSkuList (int $id, array $ids, int $productId, array $productIds, array $status, string $skuName, string $queryType, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["id" => $id, "ids" => $ids, "productId" => $productId, "productIds" => $productIds, "status" => $status, "skuName" => $skuName, "queryType" => $queryType, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取productSku-不分页
     * @return  array
    */
    public static function productSkuAllList (int $id, array $ids, int $productId, array $productIds, string $skuName, array $status, array $skuCodes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuAllList(["id" => $id, "ids" => $ids, "productId" => $productId, "productIds" => $productIds, "skuName" => $skuName, "status" => $status, "skuCodes" => $skuCodes]);
    }
    /**
     * 获取产品分页列表-分页
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10, int $type, array $types, int $groupId, array $productIds, string $name, int $categoryId, array $categoryIds, int $brandId, array $status, int $onlineSales, int $offlineSales, string $startAt, string $endAt, int $needCheckStock, bool $isOnlyShowMaterial) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "type" => $type, "types" => $types, "groupId" => $groupId, "productIds" => $productIds, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "brandId" => $brandId, "status" => $status, "onlineSales" => $onlineSales, "offlineSales" => $offlineSales, "startAt" => $startAt, "endAt" => $endAt, "needCheckStock" => $needCheckStock, "isOnlyShowMaterial" => $isOnlyShowMaterial]);
    }
    /**
     * 获取产品分页列表-不分页
     * @return  array
    */
    public static function allList (int $type, array $types, int $groupId, array $productIds, string $name, int $categoryId, array $categoryIds, int $brandId, array $status, int $onlineSales, int $offlineSales, string $startAt, string $endAt, int $needLabel, int $isCombine) {
        return RpcClass::getClass(self::$serviceName, self::$className)->allList(["type" => $type, "types" => $types, "groupId" => $groupId, "productIds" => $productIds, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "brandId" => $brandId, "status" => $status, "onlineSales" => $onlineSales, "offlineSales" => $offlineSales, "startAt" => $startAt, "endAt" => $endAt, "needLabel" => $needLabel, "isCombine" => $isCombine]);
    }
    /**
     * 获取productIds
     * @return  array
    */
    public static function getProductIds (int $type, array $types, int $groupId, array $productIds, string $name, int $categoryId, array $categoryIds, array $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductIds(["type" => $type, "types" => $types, "groupId" => $groupId, "productIds" => $productIds, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "status" => $status]);
    }
    /**
     * 根据产品productId获取skus并按照sellPrice排序
     * @return  array
    */
    public static function getSkuByProductIdsOrderBySellPrice (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuByProductIdsOrderBySellPrice(["productIds" => $productIds]);
    }
    /**
     * 根据商品类型获取零售商场所有sku列表
     * @return  array
    */
    public static function getAllSkuByType (int $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSkuByType(["type" => $type]);
    }
    /**
     * 根据productSku表的outSkuId,获取寸心对应的productSku信息
     * @return  array
    */
    public static function getProductSkuCunXinByProductSkuOutSkuId (int $outSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuCunXinByProductSkuOutSkuId(["outSkuId" => $outSkuId]);
    }
    /**
     * 根据productSku表的outSkuId,获取寸心对应的productSku信息
     * @return  array
    */
    public static function getProductSkuCunXinByProductSkuOutSkuIds (array $outSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuCunXinByProductSkuOutSkuIds(["outSkuIds" => $outSkuIds]);
    }
    /**
     * 根据productSku表的outSkuId,获取寸心对应的productSku信息
     * @return  array
    */
    public static function getProductSkuByProductSkuId (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuByProductSkuId(["productSkuId" => $productSkuId]);
    }
    /**
     * 根据productSku表的outSkuId,获取寸心对应的productSku信息
     * @return  array
    */
    public static function getProductSkuList (int $productId, int $productSkuId, array $productSkuIds, array $with) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuList(["productId" => $productId, "productSkuId" => $productSkuId, "productSkuIds" => $productSkuIds, "with" => $with]);
    }
    /**
     * 查询sku规格关联详情
     * @return  array
    */
    public static function getSkuMetricItemsBySkuIds (array $productSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuMetricItemsBySkuIds(["productSkuIds" => $productSkuIds]);
    }
    /**
     * 查询sku定制模版关联详情
     * @return  array
    */
    public static function getTemplateDetailsBySkuId (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplateDetailsBySkuId(["productSkuId" => $productSkuId]);
    }
    /**
     * 上传sku模版psd
     * @return  bool
    */
    public static function updateCustomizedTemplate (int $skuId, string $templatePath, int $openNum, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCustomizedTemplate(["skuId" => $skuId, "templatePath" => $templatePath, "openNum" => $openNum, "updateBy" => $updateBy]);
    }
    /**
     * 模版任务回调处理
     * @return  bool
    */
    public static function callbackOutSkuTemplate (string $taskId, string $type, string $outPath, string $status, string $failReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackOutSkuTemplate(["taskId" => $taskId, "type" => $type, "outPath" => $outPath, "status" => $status, "failReason" => $failReason]);
    }
    /**
     * 产品sku绑定增值服务
     * @return  bool
    */
    public static function bindAddedSku (int $productSkuId, int $serviceProductSkuId, int $createBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindAddedSku(["productSkuId" => $productSkuId, "serviceProductSkuId" => $serviceProductSkuId, "createBy" => $createBy]);
    }
    /**
     * 产品sku解绑增值服务
     * @return  bool
    */
    public static function unbindAddedSku (int $productSkuId, int $serviceProductSkuId, int $createBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindAddedSku(["productSkuId" => $productSkuId, "serviceProductSkuId" => $serviceProductSkuId, "createBy" => $createBy]);
    }
    /**
     * 定制增值服务列表
     * @return  array
    */
    public static function bindAddedSkuList (int $productSkuId, int $categoryId, int $page, string $status, int $pageSize, string $addedSkuName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindAddedSkuList(["productSkuId" => $productSkuId, "categoryId" => $categoryId, "page" => $page, "status" => $status, "pageSize" => $pageSize, "addedSkuName" => $addedSkuName]);
    }
    /**
     * 定制增值服务列表
     * @return  bool
    */
    public static function deleteProductSku (array $productSkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteProductSku(["productSkuIds" => $productSkuIds]);
    }
    /**
     * 定制增值服务列表
     * @return  bool
    */
    public static function deleteProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteProduct(["productId" => $productId]);
    }
    /**
     * 定制增值服务列表
     * @return  array
    */
    public static function getAddedSkuDetailList (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAddedSkuDetailList(["productSkuId" => $productSkuId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}