<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-07 13:57:06
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SkuProductService
 */
class SkuProductService {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "SkuProductService";

    /**
     * 拍摄产品添加sku
     * @return  mixed
    */
    public static function create (int $productId, array $skuInfos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["productId" => $productId, "skuInfos" => $skuInfos]);
    }
    /**
     * 更新拍摄产品的sku
     * @return  mixed
    */
    public static function update (int $productId, array $skuInfos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["productId" => $productId, "skuInfos" => $skuInfos]);
    }
    /**
     * 删除sku的拍摄产品
     * @return  mixed
    */
    public static function remove (int $productId, array $skuIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["productId" => $productId, "skuIds" => $skuIds]);
    }
    /**
     * 获取sku关联的拍摄产品
     * @return  mixed
    */
    public static function detail (int $productId, bool $withOffSku = false, array $skuIds = [], int $storeId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["productId" => $productId, "withOffSku" => $withOffSku, "skuIds" => $skuIds, "storeId" => $storeId]);
    }
    /**
     * 获取拍摄产品对应零售渠道sku价格
     * @return  mixed
    */
    public static function getSellPriceByProductIds (array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSellPriceByProductIds(["productIds" => $productIds]);
    }
    /**
     * 根据拍摄产品的productId获取其绑定的零售产品skuId
     * @return  mixed
    */
    public static function getRetailSkuProductServiceByProductId (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailSkuProductServiceByProductId(["productId" => $productId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}