<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-07 13:57:06
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CustomizedV2
 */
class CustomizedV2 {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Customized\\CustomizedV2";

    /**
     * 获取产品sku下所有主题数据
     * @return  array
    */
    public static function getSkuThemeList (int $skuId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuThemeList(["skuId" => $skuId]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuThemeListDTO[]"
        );
    }
    /**
     * 获取sku的主题详情信息
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuThemeTemplateDetailDTO
    */
    public static function getThemeTemplateDetail (int $skuId, int $themeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getThemeTemplateDetail(["skuId" => $skuId, "themeId" => $themeId]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuThemeTemplateDetailDTO"
        );
    }
    /**
     * 获取sku的加页增值服务，带增页模版信息
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetAddPageSkuAndTemplateDTO
    */
    public static function getAddPageSkuAndTemplate (int $skuId, int $themeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAddPageSkuAndTemplate(["skuId" => $skuId, "themeId" => $themeId]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetAddPageSkuAndTemplateDTO"
        );
    }
    /**
     * 获取当前sku模版和增值服务、贴图、背景数据信息
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetSkuTemplateWorkDetailDTO
    */
    public static function getSkuTemplateWorkDetail (int $skuId, int $themeId, string $templateType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSkuTemplateWorkDetail(["skuId" => $skuId, "themeId" => $themeId, "templateType" => $templateType]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\GetSkuTemplateWorkDetailDTO"
        );
    }
    /**
     * 获取当前sku模版和增值服务、贴图、背景数据信息
     * @return  array
    */
    public static function getSkusTemplateType (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkusTemplateType(["skuIds" => $skuIds]);
    }
    /**
     * 基础sku和增值服务绑定关系列表
     * @return  array
    */
    public static function productSkuBindServiceList (array $productSkuIds, array $serviceProductSkuIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productSkuBindServiceList(["productSkuIds" => $productSkuIds, "serviceProductSkuIds" => $serviceProductSkuIds]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ProductSkuBindServiceListDTO[]"
        );
    }
    /**
     * 基础sku和增值服务绑定关系列表
     * @return  int
    */
    public static function getSkuInitPageNum (int $productSkuId, string $templateType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuInitPageNum(["productSkuId" => $productSkuId, "templateType" => $templateType]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}