<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-18 15:07:05
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Supplier
 */
class Supplier {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Supplier";

    /**
     * 创建供应商
     * @return  bool
    */
    public static function create (int $createBy, string $name, int $deliveryCycle = 1, string $code = '', string $domain = '', string $remark = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["createBy" => $createBy, "name" => $name, "deliveryCycle" => $deliveryCycle, "code" => $code, "domain" => $domain, "remark" => $remark]);
    }
    /**
     * 修改供应商
     * @return  bool
    */
    public static function update (int $id, int $updateBy, string $name, int $deliveryCycle = 1, string $domain = '', string $remark = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "updateBy" => $updateBy, "name" => $name, "deliveryCycle" => $deliveryCycle, "domain" => $domain, "remark" => $remark]);
    }
    /**
     * 供应商列表
     * @return  array
    */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 删除供应商
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 所有供应商
     * @return  array
    */
    public static function all (string $name, array $supplierCodes) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["name" => $name, "supplierCodes" => $supplierCodes]);
    }
    /**
     * 根据ids获取供应商
     * @return  array
    */
    public static function getByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByIds(["ids" => $ids]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}