<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-18 15:07:05
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Promotion
 */
class Promotion {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Promotion";

    /**
     * 创建促销活动
     * @return  array
    */
    public static function create (int $operateId, string $code, string $name, string $description, string $cover, string $type, string $assetUrl, int $offlinePromotions, int $onlinePromotions = 0, int $offerOverlay, string $startedAt, string $endedAt, array $storeGroup, array $skuIds, array $rules, array $giveawaySkuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["operateId" => $operateId, "code" => $code, "name" => $name, "description" => $description, "cover" => $cover, "type" => $type, "assetUrl" => $assetUrl, "offlinePromotions" => $offlinePromotions, "onlinePromotions" => $onlinePromotions, "offerOverlay" => $offerOverlay, "startedAt" => $startedAt, "endedAt" => $endedAt, "storeGroup" => $storeGroup, "skuIds" => $skuIds, "rules" => $rules, "giveawaySkuIds" => $giveawaySkuIds]);
    }
    /**
     * 修改促销活动
     * @return  array
    */
    public static function update (int $id, int $operateId, int $offlinePromotions, string $name, string $startedAt, string $endedAt, array $skuIds, array $storeGroup, int $onlinePromotions = 0, string $code = '', string $description = '', string $cover = '', string $assetUrl = '', array $giveawaySkuIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "operateId" => $operateId, "offlinePromotions" => $offlinePromotions, "name" => $name, "startedAt" => $startedAt, "endedAt" => $endedAt, "skuIds" => $skuIds, "storeGroup" => $storeGroup, "onlinePromotions" => $onlinePromotions, "code" => $code, "description" => $description, "cover" => $cover, "assetUrl" => $assetUrl, "giveawaySkuIds" => $giveawaySkuIds]);
    }
    /**
     * 修改促销活动时间
     * @return  bool
    */
    public static function updateDate (int $id, int $operateId, string $startedAt, string $endedAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateDate(["id" => $id, "operateId" => $operateId, "startedAt" => $startedAt, "endedAt" => $endedAt]);
    }
    /**
     * 添加促销活动的的sku
     * @return  bool
    */
    public static function addPromotionSku (int $id, int $operateId, array $skuIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPromotionSku(["id" => $id, "operateId" => $operateId, "skuIds" => $skuIds]);
    }
    /**
     * 删除促销活动的sku
     * @return  bool
    */
    public static function removePromotionSku (int $id, int $operateId, array $skuIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removePromotionSku(["id" => $id, "operateId" => $operateId, "skuIds" => $skuIds]);
    }
    /**
     * 添加促销活动的买赠商品
     * @return  bool
    */
    public static function addPromotionGiveawaySku (int $id, int $operateId, array $giveawaySkuIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPromotionGiveawaySku(["id" => $id, "operateId" => $operateId, "giveawaySkuIds" => $giveawaySkuIds]);
    }
    /**
     * 删除促销活动的买赠商品
     * @return  bool
    */
    public static function removePromotionGiveawaySku (int $id, int $operateId, array $giveawaySkuIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removePromotionGiveawaySku(["id" => $id, "operateId" => $operateId, "giveawaySkuIds" => $giveawaySkuIds]);
    }
    /**
     * 结束促销活动
     * @return  bool
    */
    public static function finishPromotion (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishPromotion(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 获取促销活动列表
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 20, string $name = '', string $status = '', string $type = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "name" => $name, "status" => $status, "type" => $type]);
    }
    /**
     * 获取促销活动详情
     * @return  array
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 删除促销活动
     * @return  bool
    */
    public static function remove (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * onTimeChangeStatus
     * @return  mixed
    */
    public static function onTimeChangeStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->onTimeChangeStatus();
    }
    /**
     * 查询零售商品列表
     * @return  array
    */
    public static function getProductSkuList (string $type, int $page = 1, int $pageSize = 20, int $categoryId = 0, string $name = '', string $skuType = 'sku') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuList(["type" => $type, "page" => $page, "pageSize" => $pageSize, "categoryId" => $categoryId, "name" => $name, "skuType" => $skuType]);
    }
    /**
     * 查询零售渠道productSku列表
     * @return  array
    */
    public static function productSkuList (int $page = 1, int $pageSize = 20, string $type, array $categoryIds, string $skuName, bool $isOnlyShelveUp = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["page" => $page, "pageSize" => $pageSize, "type" => $type, "categoryIds" => $categoryIds, "skuName" => $skuName, "isOnlyShelveUp" => $isOnlyShelveUp]);
    }
    /**
     * 获取促销活动的商品
     * @return  array
    */
    public static function getPromotionProductSku (int $promotionId, int $page = 1, int $pageSize = 20, string $skuName = '', int $isGiveaway = 0, string $status = 'shelve') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPromotionProductSku(["promotionId" => $promotionId, "page" => $page, "pageSize" => $pageSize, "skuName" => $skuName, "isGiveaway" => $isGiveaway, "status" => $status]);
    }
    /**
     * 根据店铺和skuIds获取sku相关的促销信息
     * @return  array
    */
    public static function getSkuPromotionListByStore (int $storeId, array $skuIds, int $offlinePromotions = 1, int $onlinePromotions = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuPromotionListByStore(["storeId" => $storeId, "skuIds" => $skuIds, "offlinePromotions" => $offlinePromotions, "onlinePromotions" => $onlinePromotions]);
    }
    /**
     * 根据分类获取所有相关的零售商品
     * @return  array
    */
    public static function getAllProductSkuByCategory (int $categoryId, string $type, string $skuType = 'sku') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductSkuByCategory(["categoryId" => $categoryId, "type" => $type, "skuType" => $skuType]);
    }
    /**
     * 批量添加促销活动的sku
     * @return  bool
    */
    public static function batchAddPromotionSku (array $promotionSkuInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAddPromotionSku(["promotionSkuInfo" => $promotionSkuInfo]);
    }
    /**
     * 批量添加促销的买赠商品
     * @return  bool
    */
    public static function batchAddPromotionGiveawaySku (array $promotionGiveawaySkuInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAddPromotionGiveawaySku(["promotionGiveawaySkuInfo" => $promotionGiveawaySkuInfo]);
    }
    /**
     * 根据skuIds获取sku相关的促销信息
     * @return  array
    */
    public static function getSkuPromotionListBySkuIds (array $skuIds, int $offlinePromotions = 1, int $onlinePromotions = 0, int $isGiveaway = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuPromotionListBySkuIds(["skuIds" => $skuIds, "offlinePromotions" => $offlinePromotions, "onlinePromotions" => $onlinePromotions, "isGiveaway" => $isGiveaway]);
    }
    /**
     * 获取所有促销活动
     * @return  array
    */
    public static function allPromotion (array $ids = [], string $name = '', string $status = '', string $type = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->allPromotion(["ids" => $ids, "name" => $name, "status" => $status, "type" => $type]);
    }
    /**
     * 批量删除促销活动的sku
     * @return  bool
    */
    public static function batchRemovePromotionSku (array $promotionSkuInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchRemovePromotionSku(["promotionSkuInfo" => $promotionSkuInfo]);
    }
    /**
     * 批量删除促销的买赠商品
     * @return  bool
    */
    public static function batchRemovePromotionGiveawaySku (array $promotionGiveawaySkuInfo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchRemovePromotionGiveawaySku(["promotionGiveawaySkuInfo" => $promotionGiveawaySkuInfo]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}