<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-18 15:07:05
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Discount;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Discount
 */
class Discount {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Discount\\Discount";

    /**
     * 创建促销活动
     * @return  bool
    */
    public static function create (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountCmd $createDiscountCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createDiscountCmd);
    }
    /**
     * 更新促销活动
     * @return  bool
    */
    public static function update (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\UpdateDiscountCmd $updateDiscountCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update($updateDiscountCmd);
    }
    /**
     * 终止促销活动
     * @return  bool
    */
    public static function stop (int $id, int $updatedBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stop(["id" => $id, "updatedBy" => $updatedBy]);
    }
    /**
     * 促销活动详情
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\DTO\DiscountDetailDTO
    */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Discount\DTO\DiscountDetailDTO"
        );
    }
    /**
     * 促销活动列表
     * @return  array
    */
    public static function listWithPaginate (int $page = 1, int $pageSize = 100, int $id, array $ids, string $name, int $levelId, string $status, string $type, string $discountRelation, string $checkTime, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginate(["page" => $page, "pageSize" => $pageSize, "id" => $id, "ids" => $ids, "name" => $name, "levelId" => $levelId, "status" => $status, "type" => $type, "discountRelation" => $discountRelation, "checkTime" => $checkTime, "storeId" => $storeId]);
    }
    /**
     * 促销活动列表
     * @return  array
    */
    public static function list (int $id, array $ids, string $name, int $levelId, string $status, string $type, string $discountRelation, int $storeId, string $checkTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["id" => $id, "ids" => $ids, "name" => $name, "levelId" => $levelId, "status" => $status, "type" => $type, "discountRelation" => $discountRelation, "storeId" => $storeId, "checkTime" => $checkTime]);
    }
    /**
     * 获取未结束的促销活动列表
     * @return  array
    */
    public static function getNotStartAndInProgressDiscounts (string $type, string $discountRelation) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNotStartAndInProgressDiscounts(["type" => $type, "discountRelation" => $discountRelation]);
    }
    /**
     * 创建促销活动互斥关系
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\DTO\DiscountMutexDTO
    */
    public static function createDiscountMutex (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountMutexCmd $createDiscountMutexCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createDiscountMutex($createDiscountMutexCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Discount\DTO\DiscountMutexDTO"
        );
    }
    /**
     * 删除促销活动互斥关系
     * @return  bool
    */
    public static function deleteDiscountMutex (int $id, int $updatedBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteDiscountMutex(["id" => $id, "updatedBy" => $updatedBy]);
    }
    /**
     * 互斥关系列表
     * @return  array
    */
    public static function discountMutexList (array $discountIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->discountMutexList(["discountIds" => $discountIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}