<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-17 17:01:38
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Project
 */
class Project {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Project";

    /**
     * 新增收集计划
     * @return  array
    */
    public static function create (string $project_start, string $project_end, string $name, string $description, array $sku_info, int $creator) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["project_start" => $project_start, "project_end" => $project_end, "name" => $name, "description" => $description, "sku_info" => $sku_info, "creator" => $creator]);
    }
    /**
     * 计划列表
     * @return  mixed
    */
    public static function list (int $page = 1, int $pageSize = 20, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "name" => $name]);
    }
    /**
     * 返回导入的SKU信息
     * @return  array
    */
    public static function productImport (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productImport(["skuIds" => $skuIds]);
    }
    /**
     * 计划终止
     * @return  mixed
    */
    public static function terminate (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->terminate(["id" => $id]);
    }
    /**
     * 计划详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 计划状态更新
     * @return  mixed
    */
    public static function updateState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateState();
    }
    /**
     * 计划包含的SKU
     * @return  mixed
    */
    public static function getSkuList (int $page = 1, int $pageSize = 20, int $project_id, string $skuName, int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuList(["page" => $page, "pageSize" => $pageSize, "project_id" => $project_id, "skuName" => $skuName, "categoryId" => $categoryId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}