<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-17 17:01:38
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Product";

    /**
     * 创建产品
     * @return  mixed
    */
    public static function create (int $type, int $categoryId, string $name, array $newMainImage, array $bannerUrl, array $descriptionUrl, int $needCheckStock = 0, int $createBy, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["type" => $type, "categoryId" => $categoryId, "name" => $name, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "needCheckStock" => $needCheckStock, "createBy" => $createBy, "updateBy" => $updateBy]);
    }
    /**
     * 更新产品
     * @return  bool
    */
    public static function update (int $id, int $type, int $categoryId, int $groupId, string $name, array $newMainImage, array $bannerUrl, array $descriptionUrl, bool $needCheckStock, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "type" => $type, "categoryId" => $categoryId, "groupId" => $groupId, "name" => $name, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "needCheckStock" => $needCheckStock, "updateBy" => $updateBy]);
    }
    /**
     * 创建productSku
     * @return  bool
    */
    public static function productSkuBatchCreate (int $productId, array $productSku, array $productExtendMetric, int $createBy, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuBatchCreate(["productId" => $productId, "productSku" => $productSku, "productExtendMetric" => $productExtendMetric, "createBy" => $createBy, "updateBy" => $updateBy]);
    }
    /**
     * 产品sku数据批量导入
     * @return  array
    */
    public static function batchImportProductSku (array $data, int $createdBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchImportProductSku(["data" => $data, "createdBy" => $createdBy]);
    }
    /**
     * 更新productSku
     * @return  bool
    */
    public static function productSkuBatchUpdate (int $productId, array $productSku, array $productExtendMetric, int $updateBy) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuBatchUpdate(["productId" => $productId, "productSku" => $productSku, "productExtendMetric" => $productExtendMetric, "updateBy" => $updateBy]);
    }
    /**
     * sku价格审批列表
     * @return  array
    */
    public static function productSkuPricePendingList (int $entityId, string $entity, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuPricePendingList(["entityId" => $entityId, "entity" => $entity, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * sku价格审批列表
     * @return  bool
    */
    public static function resubmitPricePending (int $productSkuPricePendingId, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->resubmitPricePending(["productSkuPricePendingId" => $productSkuPricePendingId, "staffId" => $staffId]);
    }
    /**
     * product停用
     * @return  bool
    */
    public static function productDisable (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDisable(["productId" => $productId]);
    }
    /**
     * product启用
     * @return  bool
    */
    public static function productEnable (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productEnable(["productId" => $productId]);
    }
    /**
     * productSku停用
     * @return  bool
    */
    public static function productSkuDisable (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuDisable(["productSkuId" => $productSkuId]);
    }
    /**
     * productSku启用
     * @return  bool
    */
    public static function productSkuEnable (int $productSkuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuEnable(["productSkuId" => $productSkuId]);
    }
    /**
     * 删除产品
     * @return  bool
    */
    public static function remove (int $id, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id, "operateId" => $operateId]);
    }
    /**
     * 获取产品分页列表
     * @return  array
    */
    public static function list (int $page = 1, int $pageSize = 10, int $type, array $types, string $name, int $categoryId, array $categoryIds, int $brandId, array $status, int $onlineSales, int $offlineSales, string $startAt, string $endAt, int $needLabel, int $isCombine) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "pageSize" => $pageSize, "type" => $type, "types" => $types, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "brandId" => $brandId, "status" => $status, "onlineSales" => $onlineSales, "offlineSales" => $offlineSales, "startAt" => $startAt, "endAt" => $endAt, "needLabel" => $needLabel, "isCombine" => $isCombine]);
    }
    /**
     * 获取产品列表-不分页
     * @return  array
    */
    public static function productListWithoutPaginate (int $id, array $ids, int $type, array $types, string $name, int $categoryId, array $categoryIds, array $status, string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWithoutPaginate(["id" => $id, "ids" => $ids, "type" => $type, "types" => $types, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "status" => $status, "startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 设置产品标签
     * @return  void
    */
    public static function setTags (int $id, array $tags = []) {
         RpcClass::getClass(self::$serviceName, self::$className)->setTags(["id" => $id, "tags" => $tags]);
    }
    /**
     * 批量设置产品标签
     * @return  mixed
    */
    public static function batchSetTags (array $ids, array $updateTags = [], array $delTags = [], int $operateId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSetTags(["ids" => $ids, "updateTags" => $updateTags, "delTags" => $delTags, "operateId" => $operateId]);
    }
    /**
     * 根据产品id获取标签状态
     * @return  array
    */
    public static function getTagStatus (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTagStatus(["ids" => $ids]);
    }
    /**
     * 标签产品列表
     * @return  array
    */
    public static function getTagProductList (int $page = 1, int $pageSize = 10, int $tagId, string $productName, string $startAtBegin, string $startAtEnd, string $endAtBegin, string $endAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTagProductList(["page" => $page, "pageSize" => $pageSize, "tagId" => $tagId, "productName" => $productName, "startAtBegin" => $startAtBegin, "startAtEnd" => $startAtEnd, "endAtBegin" => $endAtBegin, "endAtEnd" => $endAtEnd]);
    }
    /**
     * 根据编码获取sku信息
     * @return  mixed
    */
    public static function getSkuBySkuCode (string $skuCode) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuBySkuCode(["skuCode" => $skuCode]);
    }
    /**
     * 根据skuIds获取sku对应的产品id
     * @return  array
    */
    public static function getProductIdsBySkuIds (array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductIdsBySkuIds(["skuIds" => $skuIds]);
    }
    /**
     * 批量对商品配置门店组
     * @return  mixed
    */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProductStoreGroup(["ids" => $ids, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds]);
    }
    /**
     * 新增零售商品sku关联门店组/门店
     * @return  mixed
    */
    public static function addProductSkuStoreGroup (int $skuId, array $storeGroupIds = [], array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductSkuStoreGroup(["skuId" => $skuId, "storeGroupIds" => $storeGroupIds, "storeIds" => $storeIds]);
    }
    /**
     * 获取商品skuId对应门店组
     * @return  mixed
    */
    public static function getProductSkuStoreGroup (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkuStoreGroup(["skuId" => $skuId]);
    }
    /**
     * 清空商品Sku与门店、门店组关系
     * @return  bool
    */
    public static function clearStoreGroupBySkuId (int $skuId, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearStoreGroupBySkuId(["skuId" => $skuId, "operateId" => $operateId]);
    }
    /**
     * 删除商品与门店关系
     * @return  bool
    */
    public static function deleteStoreGroupBySkuId (int $skuId, array $storeIds, int $operateId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStoreGroupBySkuId(["skuId" => $skuId, "storeIds" => $storeIds, "operateId" => $operateId]);
    }
    /**
     * 删除产品对应门店组
     * @return  mixed
    */
    public static function deleteProductSkuStoreGroup (int $skuId, int $groupId = 0, int $storeId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteProductSkuStoreGroup(["skuId" => $skuId, "groupId" => $groupId, "storeId" => $storeId]);
    }
    /**
     * 获取商品操作记录
     * @return  array
    */
    public static function getMessageLog (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMessageLog(["id" => $id]);
    }
    /**
     * 根据skuIds获取详情
     * @return  array
    */
    public static function getSkuBySkuIds (array $skuIds, string $from = 'mobile', bool $withOffSku = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuBySkuIds(["skuIds" => $skuIds, "from" => $from, "withOffSku" => $withOffSku]);
    }
    /**
     * 根据skuId获取详情
     * @return  array
    */
    public static function getSkuBySkuId (int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuBySkuId(["skuId" => $skuId]);
    }
    /**
     * 获取需要进行库存判断的商品sku
     * @return  array
    */
    public static function getNeedInventoryCheckSku (bool $withOffSku = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getNeedInventoryCheckSku(["withOffSku" => $withOffSku]);
    }
    /**
     * 获取所有的sku
     * @return  array
    */
    public static function getAllSku (bool $withOffSku = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllSku(["withOffSku" => $withOffSku]);
    }
    /**
     * 分页获取productSku表中商品信息，附带3级分类信息
     * @return  mixed
    */
    public static function getProductSkusWithCategory (int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkusWithCategory(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取需要进行库存判断的商品sku列表
     * @return  array
    */
    public static function getInventoryCheckSkuList (int $storeId, int $page = 1, int $pageSize = 20, bool $withOffSku = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInventoryCheckSkuList(["storeId" => $storeId, "page" => $page, "pageSize" => $pageSize, "withOffSku" => $withOffSku]);
    }
    /**
     * 根据门店id和skuIds获取对应的库存
     * @return  mixed
    */
    public static function getStockByStoreIdAndSkuIds (int $storeId, array $skuIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStockByStoreIdAndSkuIds(["storeId" => $storeId, "skuIds" => $skuIds]);
    }
    /**
     * 更新同步物料信息
     * @return  mixed
    */
    public static function updateMaterialInfo (int $productId, int $skuId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMaterialInfo(["productId" => $productId, "skuId" => $skuId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}