<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-17 17:01:38
 */
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Brand
 */
class Brand {
    private static string $serviceName = "HimoRetailProduct";

    private static string $className = "Brand";

    /**
     * 创建品牌
     * @return  bool
    */
    public static function create (int $createBy, string $name, string $introduction = '', string $imageUrl = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["createBy" => $createBy, "name" => $name, "introduction" => $introduction, "imageUrl" => $imageUrl]);
    }
    /**
     * 修改品牌
     * @return  bool
    */
    public static function update (int $id, int $updateBy, string $name, string $introduction = '', string $imageUrl = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "updateBy" => $updateBy, "name" => $name, "introduction" => $introduction, "imageUrl" => $imageUrl]);
    }
    /**
     * 品牌列表
     * @return  array
    */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 删除品牌
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 根据ids获取品牌
     * @return  array
    */
    public static function getByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByIds(["ids" => $ids]);
    }
    /**
     * 所有品牌
     * @return  array
    */
    public static function all (string $name = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["name" => $name]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}