<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Discount;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\UpdateDiscountCmd $params)
 * @method stopByParams(array $params)
 * @method detailByParams(array $params)
 * @method listWithPaginateByParams(array $params)
 * @method listByParams(array $params)
 * @method getNotStartAndInPorgressDiscountsByParams(array $params)
 * @method createDiscountMutexByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountMutexCmd $params)
 * @method updateDiscountMutexByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\UpdateDiscountMutexCmd $params)
 * @method deleteDiscountMutexByParams(array $params)
 * @method discountMutexListByParams(array $params)
 */
class Discount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建促销活动
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountCmd $createDiscountCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountCmd $createDiscountCmd) {
        return self::getClass()->create($createDiscountCmd);
    }


    /**
     * 更新促销活动
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\UpdateDiscountCmd $updateDiscountCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\UpdateDiscountCmd $updateDiscountCmd) {
        return self::getClass()->update($updateDiscountCmd);
    }


    /**
     * 终止促销活动
     *
     * @support  int $id 调价单id [ require true ]
     * @support  int $updatedBy 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stop () {
        return self::getClass()->stop([
        ]);
    }

    /**
     * 促销活动详情
     *
     * @param  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\DTO\DiscountDetailDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Discount\DTO\DiscountDetailDTO"
        );
    }

    /**
     * 促销活动列表
     *
     * @support  int $id 调价单id [ require false ]
     * @support  array $ids 调价单id数组 [ require false ]
     * @support  string $name 调价单名称 [ require false ]
     * @support  string $status 调价单状态:not_start未开始,in_progress进行中,ended已结束 [ require false ]
     * @support  string $type 活动类型：decrease打折；discount满减；pack打包一口价；markUpGift加价购 [ require false ]
     * @support  string $discountRelation 与其他活动的关系：share同享，exclusive排他，mutex互斥 [ require false ]
     * @support  array $storeIds 门店storeIds数组 [ require false ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginate (int $page = 1, int $pageSize = 100) {
        return self::getClass()->listWithPaginate([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 促销活动列表
     *
     * @support  int $id 调价单id [ require false ]
     * @support  array $ids 调价单id数组 [ require false ]
     * @support  string $name 调价单名称 [ require false ]
     * @support  string $status 调价单状态:not_start未开始,in_progress进行中,ended已结束 [ require false ]
     * @support  string $type 活动类型：decrease打折；discount满减；pack打包一口价；markUpGift加价购 [ require false ]
     * @support  string $discountRelation 与其他活动的关系：share同享，exclusive排他，mutex互斥 [ require false ]
     * @support  array $storeIds 门店storeIds数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取未结束的促销活动列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getNotStartAndInPorgressDiscounts () {
        return self::getClass()->getNotStartAndInPorgressDiscounts();
    }

    /**
     * 创建促销活动互斥关系
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountMutexCmd $createDiscountMutexCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createDiscountMutex (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\CreateDiscountMutexCmd $createDiscountMutexCmd) {
        return self::getClass()->createDiscountMutex($createDiscountMutexCmd);
    }


    /**
     * 更新促销活动互斥关系
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\UpdateDiscountMutexCmd $updateDiscountMutexCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateDiscountMutex (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\UpdateDiscountMutexCmd $updateDiscountMutexCmd) {
        return self::getClass()->updateDiscountMutex($updateDiscountMutexCmd);
    }


    /**
     * 删除促销活动互斥关系
     *
     * @support  int $id 调价单id [ require true ]
     * @support  int $updatedBy 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteDiscountMutex () {
        return self::getClass()->deleteDiscountMutex([
        ]);
    }

    /**
     * 互斥关系列表
     *
     * @support  array $discountIds 促销活动ids数组 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function discountMutexList () {
        return self::getClass()->discountMutexList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Discount\Discount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Discount\Discount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}