<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 * @method listWithPaginatorByParams(array $params)
 * @method bindTemplateByParams(array $params)
 * @method unboundTemplateByParams(array $params)
 * @method callbackOutSkuTemplateByParams(array $params)
 */
class CustomizedTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @support  string $name 模版名称 [ require false ]
     * @support  string $templatePath 模版图片 [ require true ]
     * @support  int $openNum 模版开孔数 [ require true ]
     * @support  float $imageMinSize 限制图片最小上传尺寸 [ require false ]
     * @support  string $templateType 模版类型 [ require true ]
     * @support  string $supplierCode 供应商code [ require false ]
     * @support  int $createBy 创建人 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新
     *
     * @support  int $id 模版id [ require true ]
     * @support  string $name 模版名称 [ require true ]
     * @support  string $templatePath 模版图片 [ require true ]
     * @support  string $templateType 模版类型 [ require true ]
     * @support  int $openNum 模版开孔数 [ require true ]
     * @support  float $imageMinSize 限制图片最小上传尺寸 [ require false ]
     * @support  string $supplierCode 供应商code [ require false ]
     * @support  int $updateBy 更新人 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 删除
     *
     * @param  array $ids 模版ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (array $ids) {
        return self::getClass()->delete([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $ids ids [ require false ]
     * @support  string $templateType 模版类型 [ require false ]
     * @support  int $openNum 模版开孔数 [ require false ]
     * @support  string $keyword 模版名称关键字 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取分页列表
     *
     * @support  array $ids ids [ require false ]
     * @support  string $keyword 模版名称关键字 [ require false ]
     * @support  int $productSkuId 商品skuId [ require false ]
     * @support  string $templateType 模版类型 [ require false ]
     * @support  array $no_ids 排除ids [ require false ]
     * @support  int $page 第几页 [ require true ]
     * @support  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginator () {
        return self::getClass()->listWithPaginator([
        ]);
    }

    /**
     * 绑定模版
     *
     * @support  int $productSkuId 商品skuId [ require true ]
     * @support  array $customizedTemplateIds 定制模版ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindTemplate () {
        return self::getClass()->bindTemplate([
        ]);
    }

    /**
     * 解除绑定模版
     *
     * @support  int $productSkuId 商品skuId [ require true ]
     * @support  array $customizedTemplateIds 定制模版ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unboundTemplate () {
        return self::getClass()->unboundTemplate([
        ]);
    }

    /**
     * 模版任务回调处理
     *
     * @support  string $taskId 随机任务号 [ require true ]
     * @support  string $type 任务类型 [ require true ]
     * @support  string $outPath 目标存储路径 [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $failReason 错误描述；状态为fail是携带 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function callbackOutSkuTemplate () {
        return self::getClass()->callbackOutSkuTemplate([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'CustomizedTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'CustomizedTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}