<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Discount;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bestSkuCaleByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\BestSkuCalcCmd $params)
 * @method pointSkuCaleByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\PointSkuCalcCmd $params)
 * @method getDiscountListBySkuIdsByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\GetDiscountListCmd $params)
 */
class SkuCalc {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 计算产品价格并返回计算详情
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\BestSkuCalcCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function bestSkuCale (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\BestSkuCalcCmd $cmd) {
        return self::getClass()->bestSkuCale($cmd);
    }


    /**
     * 指定参加活动和排序处理计算优惠信息
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\PointSkuCalcCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function pointSkuCale (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\PointSkuCalcCmd $cmd) {
        return self::getClass()->pointSkuCale($cmd);
    }


    /**
     * 根据skuids获取对应可参加的活动
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\GetDiscountListCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDiscountListBySkuIds (\Mainto\Bridge\Structs\HimoRetailProduct\Discount\Cmd\SkuCale\GetDiscountListCmd $cmd) {
        return self::getClass()->getDiscountListBySkuIds($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Discount\SkuCalc');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Discount\SkuCalc');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}