<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateDateByParams(array $params)
 * @method addPromotionSkuByParams(array $params)
 * @method removePromotionSkuByParams(array $params)
 * @method addPromotionGiveawaySkuByParams(array $params)
 * @method removePromotionGiveawaySkuByParams(array $params)
 * @method finishPromotionByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method onTimeChangeStatusByParams(array $params)
 * @method getProductSkuListByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method getPromotionProductSkuByParams(array $params)
 * @method getSkuPromotionListByStoreByParams(array $params)
 * @method getAllProductSkuByCategoryByParams(array $params)
 * @method batchAddPromotionSkuByParams(array $params)
 * @method batchAddPromotionGiveawaySkuByParams(array $params)
 * @method getSkuPromotionListBySkuIdsByParams(array $params)
 * @method allPromotionByParams(array $params)
 * @method batchRemovePromotionSkuByParams(array $params)
 * @method batchRemovePromotionGiveawaySkuByParams(array $params)
 */
class Promotion {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建促销活动
     *
     * @support  string $code 活动编号 [ require false ]
     * @support  string $name 产品名称 [ require true ]
     * @support  string $description 活动描述 [ require false ]
     * @support  string $cover 活动主图 [ require false ]
     * @support  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @support  string $assetUrl 活动链接地址 [ require false ]
     * @support  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) [ require true ]
     * @support  int $onlinePromotions 线上活动:1 是 0 否(现在不用) [ require false ]
     * @support  int $offerOverlay 优惠叠加:1 是 0 否 [ require true ]
     * @support  string $startedAt 开始时间 [ require true ]
     * @support  string $endedAt 结束时间 [ require true ]
     * @support  array $storeGroup 关联店铺分组 [ require false ]
     * @support  array $skuIds 渠道商品的sku_id [ require true ]
     * @support  array $rules 活动规则 [ require true ]
     * @support  array $giveawaySkuIds 赠品的sku_id [ require false ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create (int $operateId) {
        return self::getClass()->create([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改促销活动
     *
     * @param  int $id 活动id [ require true ]
     * @param  string $name 产品名称 [ require true ]
     * @param  string $code 活动编号 [ require false ]
     * @param  string $description 活动描述 [ require false ]
     * @param  string $cover 活动主图 [ require false ]
     * @param  string $assetUrl 活动链接地址 [ require false ]
     * @param  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) [ require true ]
     * @param  int $onlinePromotions 线上活动:1 是 0 否(现在不用) [ require false ]
     * @param  string $startedAt 开始时间 [ require true ]
     * @param  string $endedAt 结束时间 [ require true ]
     * @param  array $storeGroup 关联店铺分组 [ require true ]
     * @param  array $skuIds 商品的sku_id [ require true ]
     * @param  array $giveawaySkuIds 赠品的sku_id [ require false ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, int $operateId, int $offlinePromotions, string $name, string $startedAt, string $endedAt, array $skuIds, array $storeGroup, int $onlinePromotions = 0, string $code = '', string $description = '', string $cover = '', string $assetUrl = '', array $giveawaySkuIds = []) {
        return self::getClass()->update([
            "id" => $id,
            "operateId" => $operateId,
            "offlinePromotions" => $offlinePromotions,
            "name" => $name,
            "startedAt" => $startedAt,
            "endedAt" => $endedAt,
            "skuIds" => $skuIds,
            "storeGroup" => $storeGroup,
            "onlinePromotions" => $onlinePromotions,
            "code" => $code,
            "description" => $description,
            "cover" => $cover,
            "assetUrl" => $assetUrl,
            "giveawaySkuIds" => $giveawaySkuIds,
        ]);
    }

    /**
     * 修改促销活动时间
     *
     * @param  int $id 活动id [ require true ]
     * @param  string $startedAt 开始时间 [ require true ]
     * @param  string $endedAt 结束时间 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateDate (int $id, int $operateId, string $startedAt, string $endedAt) {
        return self::getClass()->updateDate([
            "id" => $id,
            "operateId" => $operateId,
            "startedAt" => $startedAt,
            "endedAt" => $endedAt,
        ]);
    }

    /**
     * 添加促销活动的的sku
     *
     * @param  int $id 活动id [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addPromotionSku (int $id, int $operateId, array $skuIds = []) {
        return self::getClass()->addPromotionSku([
            "id" => $id,
            "operateId" => $operateId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 删除促销活动的sku
     *
     * @param  int $id 活动id [ require true ]
     * @param  array $skuIds 添加的sku数组 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function removePromotionSku (int $id, int $operateId, array $skuIds = []) {
        return self::getClass()->removePromotionSku([
            "id" => $id,
            "operateId" => $operateId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 添加促销活动的买赠商品
     *
     * @param  int $id 活动id [ require true ]
     * @param  array $giveawaySkuIds 赠品的sku_id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addPromotionGiveawaySku (int $id, int $operateId, array $giveawaySkuIds = []) {
        return self::getClass()->addPromotionGiveawaySku([
            "id" => $id,
            "operateId" => $operateId,
            "giveawaySkuIds" => $giveawaySkuIds,
        ]);
    }

    /**
     * 删除促销活动的买赠商品
     *
     * @param  int $id 活动id [ require true ]
     * @param  array $giveawaySkuIds 赠品的sku_id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function removePromotionGiveawaySku (int $id, int $operateId, array $giveawaySkuIds = []) {
        return self::getClass()->removePromotionGiveawaySku([
            "id" => $id,
            "operateId" => $operateId,
            "giveawaySkuIds" => $giveawaySkuIds,
        ]);
    }

    /**
     * 结束促销活动
     *
     * @param  int $id 活动id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function finishPromotion (int $id, int $operateId) {
        return self::getClass()->finishPromotion([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取促销活动列表
     *
     * @param  string $name 名称(模糊查询) [ require false ]
     * @param  string $status 状态:processing 进行中 ,waiting 未开始 ,over 已结束 [ require false ]
     * @param  string $type 类型 [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 20, string $name = '', string $status = '', string $type = '') {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
            "name" => $name,
            "status" => $status,
            "type" => $type,
        ]);
    }

    /**
     * 获取促销活动详情
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除促销活动
     *
     * @param  int $id 活动id [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 自动修改活动的状态(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function onTimeChangeStatus () {
        return self::getClass()->onTimeChangeStatus();
    }

    /**
     * 查询零售商品列表
     *
     * @param  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @param  int $categoryId 分类id [ require false ]
     * @param  string $name 产品名称 [ require false ]
     * @param  string $skuType sku类型:sku,giveaeway [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuList (string $type, int $page = 1, int $pageSize = 20, int $categoryId = 0, string $name = '', string $skuType = 'sku') {
        return self::getClass()->getProductSkuList([
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
            "categoryId" => $categoryId,
            "name" => $name,
            "skuType" => $skuType,
        ]);
    }

    /**
     * 查询零售渠道productSku列表
     *
     * @support  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @support  array $categoryIds 分类id数组 [ require false ]
     * @support  string $skuName skuName [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->productSkuList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取促销活动的商品
     *
     * @param  int $promotionId 促销活动id [ require true ]
     * @param  string $skuName 产品名称 [ require false ]
     * @param  int $isGiveaway 是否是赠品:0 否 1 是 [ require false ]
     * @param  string $status 是否是上架商品: shelve 已上架商品sku unshelve 未上架商品sku [ require false ]
     * @param  int $page 当前页 [ require false ]
     * @param  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPromotionProductSku (int $promotionId, int $page = 1, int $pageSize = 20, string $skuName = '', int $isGiveaway = 0, string $status = 'shelve') {
        return self::getClass()->getPromotionProductSku([
            "promotionId" => $promotionId,
            "page" => $page,
            "pageSize" => $pageSize,
            "skuName" => $skuName,
            "isGiveaway" => $isGiveaway,
            "status" => $status,
        ]);
    }

    /**
     * 根据店铺和skuIds获取sku相关的促销信息
     *
     * @param  int $storeId 店铺id [ require true ]
     * @param  array $skuIds skuIds [ require true ]
     * @param  int $offlinePromotions 线下活动 [ require false ]
     * @param  int $onlinePromotions 线上活动 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuPromotionListByStore (int $storeId, array $skuIds, int $offlinePromotions = 1, int $onlinePromotions = 0) {
        return self::getClass()->getSkuPromotionListByStore([
            "storeId" => $storeId,
            "skuIds" => $skuIds,
            "offlinePromotions" => $offlinePromotions,
            "onlinePromotions" => $onlinePromotions,
        ]);
    }

    /**
     * 根据分类获取所有相关的零售商品
     *
     * @param  string $type 活动类型:满减/一口价/打折/买赠 [ require true ]
     * @param  int $categoryId 分类id [ require true ]
     * @param  string $skuType sku类型:sku,giveaeway [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductSkuByCategory (int $categoryId, string $type, string $skuType = 'sku') {
        return self::getClass()->getAllProductSkuByCategory([
            "categoryId" => $categoryId,
            "type" => $type,
            "skuType" => $skuType,
        ]);
    }

    /**
     * 批量添加促销活动的sku
     *
     * @param  array $promotionSkuInfo 待批添加的数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchAddPromotionSku (array $promotionSkuInfo) {
        return self::getClass()->batchAddPromotionSku([
            "promotionSkuInfo" => $promotionSkuInfo,
        ]);
    }

    /**
     * 批量添加促销的买赠商品
     *
     * @param  array $promotionGiveawaySkuInfo 待批添加的数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchAddPromotionGiveawaySku (array $promotionGiveawaySkuInfo) {
        return self::getClass()->batchAddPromotionGiveawaySku([
            "promotionGiveawaySkuInfo" => $promotionGiveawaySkuInfo,
        ]);
    }

    /**
     * 根据skuIds获取sku相关的促销信息
     *
     * @param  array $skuIds skuIds [ require true ]
     * @param  int $isGiveaway 是否是赠品 [ require false ]
     * @param  int $offlinePromotions 线下活动 [ require false ]
     * @param  int $onlinePromotions 线上活动 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuPromotionListBySkuIds (array $skuIds, int $offlinePromotions = 1, int $onlinePromotions = 0, int $isGiveaway = 0) {
        return self::getClass()->getSkuPromotionListBySkuIds([
            "skuIds" => $skuIds,
            "offlinePromotions" => $offlinePromotions,
            "onlinePromotions" => $onlinePromotions,
            "isGiveaway" => $isGiveaway,
        ]);
    }

    /**
     * 获取所有促销活动
     *
     * @param  array $ids 促销活动id [ require false ]
     * @param  string $name 名称(模糊查询) [ require false ]
     * @param  string $status 状态:processing 进行中 ,waiting 未开始 ,over 已结束 [ require false ]
     * @param  string $type 类型 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allPromotion (array $ids = [], string $name = '', string $status = '', string $type = '') {
        return self::getClass()->allPromotion([
            "ids" => $ids,
            "name" => $name,
            "status" => $status,
            "type" => $type,
        ]);
    }

    /**
     * 批量删除促销活动的sku
     *
     * @param  array $promotionSkuInfo 待批添加的数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchRemovePromotionSku (array $promotionSkuInfo) {
        return self::getClass()->batchRemovePromotionSku([
            "promotionSkuInfo" => $promotionSkuInfo,
        ]);
    }

    /**
     * 批量删除促销的买赠商品
     *
     * @param  array $promotionGiveawaySkuInfo 待批添加的数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchRemovePromotionGiveawaySku (array $promotionGiveawaySkuInfo) {
        return self::getClass()->batchRemovePromotionGiveawaySku([
            "promotionGiveawaySkuInfo" => $promotionGiveawaySkuInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Promotion');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Promotion');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}