<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method createProductAndProductSkuByParams(array $params)
 * @method productSkuDetailByParams(array $params)
 * @method productDetailWithSkuByParams(array $params)
 * @method copyProductSkuByParams(array $params)
 * @method updateProductSkuByParams(array $params)
 * @method productListByParams(array $params)
 * @method shelveProductByParams(array $params)
 * @method unShelveProductByParams(array $params)
 * @method productListWithPaginateByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method getSkuByTypeByParams(array $params)
 * @method productSkuListWithPaginateByParams(array $params)
 * @method shelveProductSkuByParams(array $params)
 * @method getProductByIdByParams(array $params)
 * @method getProductSkuByProductIdByParams(array $params)
 * @method unshelveProductSkuByParams(array $params)
 * @method getStockByStoreIdAndSkuIdsByParams(array $params)
 * @method getStoreIdsBySellChannelSkuIdByParams(array $params)
 * @method getStoreIdsBySellChannelSkuIdsByParams(array $params)
 * @method updateProductByParams(array $params)
 * @method batchUpdateProductSkuSellPriceByParams(array $params)
 * @method batchUpdateGiftProductSkuByParams(array $params)
 * @method getProductSkuIdsBySellChannelIdByParams(array $params)
 * @method autoUpdateGiftProductSkuByParams(array $params)
 */
class SellChannel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建销售渠道
     *
     * @support  string $name 渠道名称 [ require true ]
     * @support  string $code 销售渠道code [ require false ]
     * @support  int $isStoreSell 是否门店售卖 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 销售渠道列表
     *
     * @support  int $id 渠道id [ require false ]
     * @support  array $ids 渠道id数组 [ require false ]
     * @support  string $code 渠道code [ require false ]
     * @support  array $codes 渠道code数组 [ require false ]
     * @support  string $name 渠道名称 [ require false ]
     * @support  int $isStoreSell 是否门店售卖 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 销售渠道创建productSku
     *
     * @support  mixed $content  [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createProductAndProductSku () {
        return self::getClass()->createProductAndProductSku([
        ]);
    }

    /**
     * 销售渠道productSku详情
     *
     * @param  int $sellChannelProductSkuId 渠道商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuDetail (int $sellChannelProductSkuId) {
        return self::getClass()->productSkuDetail([
            "sellChannelProductSkuId" => $sellChannelProductSkuId,
        ]);
    }

    /**
     * 根据产品id获取产品和sku
     *
     * @param  int $id 渠道商品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDetailWithSku (int $id) {
        return self::getClass()->productDetailWithSku([
            "id" => $id,
        ]);
    }

    /**
     * 复制渠道商品sku
     *
     * @support  int $sellChannelProductSkuId 渠道商品productSkuId [ require true ]
     * @support  string $sellChannelSkuName 拍摄自定义的productSkuName别名 [ require false ]
     * @support  string $sellChannelSkuImage 拍摄自定义的productSkuImage图片 [ require false ]
     * @support  float $sellPrice 售价 [ require false ]
     * @support  float $settlementPrice 结算价格 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function copyProductSku () {
        return self::getClass()->copyProductSku([
        ]);
    }

    /**
     * 销售渠道更新productSku
     *
     * @support  int $sellChannelProductSkuId 渠道商品productSkuId [ require true ]
     * @support  string $sellChannelSkuName 拍摄自定义的productSkuName别名 [ require false ]
     * @support  string $sellChannelSkuImage 拍摄自定义的productSkuImage图片 [ require false ]
     * @support  string $outSkuCode 天猫有赞关联的 外部编码 [ require false ]
     * @support  float $sellPrice 售价 [ require false ]
     * @support  float $settlementPrice 结算价格 [ require false ]
     * @support  int $updateBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProductSku () {
        return self::getClass()->updateProductSku([
        ]);
    }

    /**
     * 销售渠道product列表
     *
     * @support  array $ids 渠道productId数组 [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  int $type 产品类型 [ require false ]
     * @support  array $categoryIds 分类categoryId数组 [ require false ]
     * @support  string $productName 商品名称productName [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productList () {
        return self::getClass()->productList([
        ]);
    }

    /**
     * 批量销售渠道上架product
     *
     * @param  array $sellChannelProductIds 销售渠道productIds数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function shelveProduct (array $sellChannelProductIds) {
        return self::getClass()->shelveProduct([
            "sellChannelProductIds" => $sellChannelProductIds,
        ]);
    }

    /**
     * 批量销售渠道下架product
     *
     * @param  array $sellChannelProductIds 销售渠道productIds数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unShelveProduct (array $sellChannelProductIds) {
        return self::getClass()->unShelveProduct([
            "sellChannelProductIds" => $sellChannelProductIds,
        ]);
    }

    /**
     * 销售渠道product列表 - 分页
     *
     * @support  array $ids 渠道productId数组 [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  array $categoryIds 分类categoryIds数组 [ require false ]
     * @support  string $productName 商品名称productName [ require false ]
     * @support  string $status 商品状态 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productListWithPaginate () {
        return self::getClass()->productListWithPaginate([
        ]);
    }

    /**
     * 获取渠道productSku列表
     *
     * @support  array $ids 渠道productSkuId数组 [ require false ]
     * @support  array $productSkuIds 定制productSkuIds数组 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  array $categoryIds 销售渠道productSkuId数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  string $skuCode 销售渠道skuCode [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuList () {
        return self::getClass()->productSkuList([
        ]);
    }

    /**
     * 获取渠道productSku列表
     *
     * @support  int $type 产品类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuByType () {
        return self::getClass()->getSkuByType([
        ]);
    }

    /**
     * 销售渠道productSku列表 - 分页
     *
     * @support  array $ids 渠道skuIds数组 [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  array $sellChannelProductIds 渠道商品spuIds [ require false ]
     * @support  array $categoryIds 销售渠道productSkuId数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  string $skuCode 销售渠道skuCode [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuListWithPaginate () {
        return self::getClass()->productSkuListWithPaginate([
        ]);
    }

    /**
     * 批量销售渠道上架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function shelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->shelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * 根据产品id，仅获取product主要信息
     *
     * @param  int $id 商品productId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductById (int $id) {
        return self::getClass()->getProductById([
            "id" => $id,
        ]);
    }

    /**
     * 根据产品id，仅获取product主要信息
     *
     * @param  int $id 商品productId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuByProductId (int $id) {
        return self::getClass()->getProductSkuByProductId([
            "id" => $id,
        ]);
    }

    /**
     * 批量销售渠道下架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->unshelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * 根据门店id和渠道skuIds获取对应的库存
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  array $skuIds 渠道skuIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockByStoreIdAndSkuIds (int $storeId, array $skuIds) {
        return self::getClass()->getStockByStoreIdAndSkuIds([
            "storeId" => $storeId,
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 根据渠道skuId获取在售卖的门店ids
     *
     * @param  int $skuId 渠道skuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreIdsBySellChannelSkuId (int $skuId) {
        return self::getClass()->getStoreIdsBySellChannelSkuId([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 根据渠道skuIds获取在售卖的门店ids
     *
     * @param  array $skuIds 渠道skuIds [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreIdsBySellChannelSkuIds (array $skuIds) {
        return self::getClass()->getStoreIdsBySellChannelSkuIds([
            "skuIds" => $skuIds,
        ]);
    }

    /**
     * 更新渠道spu数据
     *
     * @support  int $sellChannelProductId 渠道商品productId [ require true ]
     * @support  string $name 产品名称 [ require false ]
     * @support  array $newMainImage 商品主图复杂对象 [ require false ]
     * @support  array $bannerUrl 商品banner图复杂对象 [ require false ]
     * @support  array $descriptionUrl 商品描述图对象 [ require false ]
     * @support  string $status 状态：shelve上架，unshelve下架 [ require false ]
     * @support  int $updateBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProduct () {
        return self::getClass()->updateProduct([
        ]);
    }

    /**
     * 批量设置productSku的sellPrice
     *
     * @support  array $productSkus 修改数据 [ require true ]
     * @support  int $updateBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdateProductSkuSellPrice () {
        return self::getClass()->batchUpdateProductSkuSellPrice([
        ]);
    }

    /**
     * 批量设置赠品Sku
     *
     * @support  array $skuIds 渠道skuids [ require true ]
     * @support  int $discountId 当前更新活动id [ require false ]
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  array $storeIds 渠道skuids [ require true ]
     * @support  int $updateBy 更新人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdateGiftProductSku () {
        return self::getClass()->batchUpdateGiftProductSku([
        ]);
    }

    /**
     * 获取某渠道下所有的skuIds-不分页
     *
     * @param  int $sellChannelId 渠道sellChannelId,1零售，2拍摄，3天猫，4有赞，5定制商城，6赠品 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuIdsBySellChannelId (int $sellChannelId) {
        return self::getClass()->getProductSkuIdsBySellChannelId([
            "sellChannelId" => $sellChannelId,
        ]);
    }

    /**
     * 每半小时自动检测礼品sku价格是否相同，并同步
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function autoUpdateGiftProductSku () {
        return self::getClass()->autoUpdateGiftProductSku();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'SellChannel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'SellChannel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}