<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method delByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method shelveByParams(array $params)
 * @method listByParams(array $params)
 * @method ListWithPaginateByParams(array $params)
 */
class SearchKeywords {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据ids获取供应商
     *
     * @support  string $keyword 搜索关键字 [ require true ]
     * @support  int $sort 排序值 [ require false ]
     * @support  int $createdBy 创建人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 根据ids获取供应商
     *
     * @support  string $keyword 搜索关键字 [ require true ]
     * @support  int $sort 排序值 [ require false ]
     * @support  int $id id [ require true ]
     * @support  int $updatedBy 创建人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 删除热词
     *
     * @support  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function del () {
        return self::getClass()->del([
        ]);
    }

    /**
     * 批量禁用
     *
     * @support  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unshelve () {
        return self::getClass()->unshelve([
        ]);
    }

    /**
     * 批量启用
     *
     * @support  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function shelve () {
        return self::getClass()->shelve([
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $ids ids [ require false ]
     * @support  string $status 状态：shelve启用，unshelve禁用 [ require false ]
     * @support  string $keyword 搜索关键字 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 获取列表
     *
     * @support  array $ids ids [ require false ]
     * @support  string $status 状态：shelve启用，unshelve禁用 [ require false ]
     * @support  string $keyword 搜索关键字 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function ListWithPaginate () {
        return self::getClass()->ListWithPaginate([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'SearchKeywords');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'SearchKeywords');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}