<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method stopByParams(array $params)
 * @method listByParams(array $params)
 */
class AdjustPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建条件单
     *
     * @support  string $name 调价单名称 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $description 调价单活动描述 [ require true ]
     * @support  array $storeGroupIds 参与门店组id [ require false ]
     * @support  array $storeIds 参与门店id数组 [ require true ]
     * @support  array $productSkus productSku调价信息 [ require true ]
     * @support  int $createBy 创建人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新条件单
     *
     * @support  int $id 调价单id [ require true ]
     * @support  string $name 调价单名称 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $description 调价单活动描述 [ require true ]
     * @support  array $storeGroupIds 参与门店组id [ require false ]
     * @support  array $storeIds 参与门店id数组 [ require false ]
     * @support  array $productSkus productSku调价信息 [ require true ]
     * @support  int $updateBy 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 终止条件单
     *
     * @support  int $id 调价单id [ require true ]
     * @support  int $updateBy 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stop () {
        return self::getClass()->stop([
        ]);
    }

    /**
     * 调价单列表
     *
     * @support  string $name 调价单名称 [ require true ]
     * @support  string $status 调价单状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'AdjustPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'AdjustPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}