<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method stopByParams(array $params)
 * @method detailByParams(array $params)
 * @method listWithPaginateByParams(array $params)
 * @method getAvailableAdjustPriceProductSkuStoresByParams(array $params)
 */
class AdjustPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建调价单
     *
     * @support  string $name 调价单名称 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $description 调价单活动描述 [ require true ]
     * @support  int $sellChannelId 渠道id [ require true ]
     * @support  array $storeGroupIds 参与门店组id [ require false ]
     * @support  array $storeIds 参与门店id数组 [ require true ]
     * @support  array $productSkus productSku调价信息 [ require true ]
     * @support  int $createBy 创建人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新调价单
     *
     * @support  int $id 调价单id [ require true ]
     * @support  string $name 调价单名称 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $description 调价单活动描述 [ require true ]
     * @support  array $storeGroupIds 参与门店组id [ require false ]
     * @support  array $storeIds 参与门店id数组 [ require false ]
     * @support  array $productSkus productSku调价信息 [ require true ]
     * @support  int $updateBy 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 终止调价单
     *
     * @support  int $id 调价单id [ require true ]
     * @support  int $updateBy 操作人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stop () {
        return self::getClass()->stop([
        ]);
    }

    /**
     * 调价单详情
     *
     * @param  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调价单列表
     *
     * @support  string $name 调价单名称 [ require false ]
     * @support  string $status 调价单状态:not_start未开始,in_progress进行中,ended已结束 [ require false ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginate (int $page = 1, int $pageSize = 100) {
        return self::getClass()->listWithPaginate([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取某个门店当前时间可用使用的调价单
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailableAdjustPriceProductSkuStores (int $storeId) {
        return self::getClass()->getAvailableAdjustPriceProductSkuStores([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'AdjustPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'AdjustPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}