<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentCmd $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method listWithPaginateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListWithPaginateCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $params)
 * @method createComponentItemByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentItemCmd $params)
 * @method updateComponentItemByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentItemCmd $params)
 * @method deleteComponentItemByParams(array $params)
 * @method getComponentItemDetailByParams(array $params)
 * @method getComponentItemListByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListCmd $params)
 * @method getComponentItemListWithPaginateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginateCmd $params)
 * @method componentBindItemsByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentBindItemsCmd $params)
 * @method getComponentItemsListWithBindByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\GetComponentItemsListWithBindCmd $params)
 * @method componentBindSkusByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\SkuBindComponentsCmd $params)
 * @method getComponentSkuListWithBindByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\GetComponentSkuListWithBindCmd $params)
 */
class CustomizedComponent {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建促销活动
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentCmd $createComponentCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentCmd $createComponentCmd) {
        return self::getClass()->create($createComponentCmd);
    }


    /**
     * 更新促销活动
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentCmd $updateComponentCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentCmd $updateComponentCmd) {
        return self::getClass()->update($updateComponentCmd);
    }


    /**
     * 更新促销活动
     *
     * @param  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 促销活动详情
     *
     * @param  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO"
        );
    }

    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListWithPaginateCmd $componentListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentListWithPaginateDTO
     */
    public static function listWithPaginate (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListWithPaginateCmd $componentListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWithPaginate($componentListWithPaginateCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentListWithPaginateDTO"
        );
    }


    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO[]
     */
    public static function list (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($componentListCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO[]"
        );
    }


    /**
     * 创建模板组
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentItemCmd $createComponentItemCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createComponentItem (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentItemCmd $createComponentItemCmd) {
        return self::getClass()->createComponentItem($createComponentItemCmd);
    }


    /**
     * 更新模板组
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentItemCmd $updateComponentItemCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateComponentItem (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentItemCmd $updateComponentItemCmd) {
        return self::getClass()->updateComponentItem($updateComponentItemCmd);
    }


    /**
     * 删除模板组
     *
     * @param  int $id 子模板id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteComponentItem (int $id) {
        return self::getClass()->deleteComponentItem([
            "id" => $id,
        ]);
    }

    /**
     * 模板组详情
     *
     * @param  int $id 子模板id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemDTO
     */
    public static function getComponentItemDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getComponentItemDetail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemDTO"
        );
    }

    /**
     * 模板组列表-不分页
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListCmd $componentItemListCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function getComponentItemList (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListCmd $componentItemListCmd) {
        return self::getClass()->getComponentItemList($componentItemListCmd);
    }


    /**
     * 模板组列表-分页
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginateCmd $componentItemListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemListWithPaginateDTO
     */
    public static function getComponentItemListWithPaginate (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginateCmd $componentItemListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getComponentItemListWithPaginate($componentItemListWithPaginateCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemListWithPaginateDTO"
        );
    }


    /**
     * 模板组绑定贴图
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentBindItemsCmd $componentBindItemsCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function componentBindItems (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentBindItemsCmd $componentBindItemsCmd) {
        return self::getClass()->componentBindItems($componentBindItemsCmd);
    }


    /**
     * 模板绑定列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\GetComponentItemsListWithBindCmd $componentBindItemsListCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getComponentItemsListWithBind (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\GetComponentItemsListWithBindCmd $componentBindItemsListCmd) {
        return self::getClass()->getComponentItemsListWithBind($componentBindItemsListCmd);
    }


    /**
     * sku绑定模板组
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\SkuBindComponentsCmd $skuBindComponentsCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function componentBindSkus (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\SkuBindComponentsCmd $skuBindComponentsCmd) {
        return self::getClass()->componentBindSkus($skuBindComponentsCmd);
    }


    /**
     * sku绑定模板组列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\GetComponentSkuListWithBindCmd $getComponentSkuListWithBindCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getComponentSkuListWithBind (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\GetComponentSkuListWithBindCmd $getComponentSkuListWithBindCmd) {
        return self::getClass()->getComponentSkuListWithBind($getComponentSkuListWithBindCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Customized\CustomizedComponent');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Customized\CustomizedComponent');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}