<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateThemeCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateThemeCmd $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listWithPaginateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ThemeListWithPaginateCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ThemeListCmd $params)
 * @method themeGroupListByParams(array $params)
 * @method createThemeGroupByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateThemeGroupCmd $params)
 * @method updateThemeGroupByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateThemeGroupCmd $params)
 * @method deleteThemeGroupByParams(array $params)
 * @method getSkuThemesByParams(array $params)
 * @method skuListWithPaginatorByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\SkuListWithPaginatorCmd $params)
 * @method templateListWithPaginatorByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\TemplateListWithPaginatorCmd $params)
 * @method getThemePageRangeByParams(array $params)
 * @method componentItemListWithPaginatorByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginatorCmd $params)
 */
class CustomizedTheme {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建主题
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateThemeCmd $createThemeCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateThemeCmd $createThemeCmd) {
        return self::getClass()->create($createThemeCmd);
    }


    /**
     * 更新主题
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateThemeCmd $updateThemeCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateThemeCmd $updateThemeCmd) {
        return self::getClass()->update($updateThemeCmd);
    }


    /**
     * 主题详情
     *
     * @param  int $id 促销活动id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeDTO"
        );
    }

    /**
     * 专题删除
     *
     * @param  int $id 促销活动id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 专题列表-分页
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ThemeListWithPaginateCmd $themeListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeListWithPaginateDTO
     */
    public static function listWithPaginate (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ThemeListWithPaginateCmd $themeListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWithPaginate($themeListWithPaginateCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeListWithPaginateDTO"
        );
    }


    /**
     * 专题列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ThemeListCmd $themeListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeDTO[]
     */
    public static function list (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ThemeListCmd $themeListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($themeListCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeDTO[]"
        );
    }


    /**
     * 专题分组列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeGroupDTO[]
     */
    public static function themeGroupList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->themeGroupList(),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ThemeGroupDTO[]"
        );
    }

    /**
     * 创建专题分组
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateThemeGroupCmd $createThemeGroupCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createThemeGroup (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateThemeGroupCmd $createThemeGroupCmd) {
        return self::getClass()->createThemeGroup($createThemeGroupCmd);
    }


    /**
     * 更新专题分组
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateThemeGroupCmd $updateThemeGroupCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateThemeGroup (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateThemeGroupCmd $updateThemeGroupCmd) {
        return self::getClass()->updateThemeGroup($updateThemeGroupCmd);
    }


    /**
     * 删除主题分组
     *
     * @param  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteThemeGroup (int $id) {
        return self::getClass()->deleteThemeGroup([
            "id" => $id,
        ]);
    }

    /**
     * 获取sku的主题ids
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuThemes (int $skuId) {
        return self::getClass()->getSkuThemes([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 创建主题筛选sku列表-分页
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\SkuListWithPaginatorCmd $skuListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuListWithPaginatorDTO
     */
    public static function skuListWithPaginator (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\SkuListWithPaginatorCmd $skuListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->skuListWithPaginator($skuListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\SkuListWithPaginatorDTO"
        );
    }


    /**
     * 创建主题可用模版列表-分页
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\TemplateListWithPaginatorCmd $templateListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\TemplateListWithPaginatorDTO
     */
    public static function templateListWithPaginator (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\TemplateListWithPaginatorCmd $templateListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->templateListWithPaginator($templateListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\TemplateListWithPaginatorDTO"
        );
    }


    /**
     * 创建主题获取书册页数范围
     *
     * @param  array $productSkuIds 选中产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getThemePageRange (array $productSkuIds) {
        return self::getClass()->getThemePageRange([
            "productSkuIds" => $productSkuIds,
        ]);
    }

    /**
     * 创建主题可用背景/贴图列表-分页
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginatorCmd $componentItemListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemsWithPaginatorDTO
     */
    public static function componentItemListWithPaginator (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginatorCmd $componentItemListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->componentItemListWithPaginator($componentItemListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemsWithPaginatorDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Customized\CustomizedTheme');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Customized\CustomizedTheme');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}