<?php
namespace Mainto\Bridge\Invokes\HimoRetailProduct\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentCmd $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method listWithPaginateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListWithPaginateCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $params)
 * @method createComponentItemByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $params)
 * @method updateComponentItemByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $params)
 * @method deleteComponentItemByParams(array $params)
 * @method componentItemListByParams(array $params)
 * @method componentItemListWithPaginateByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginateCmd $params)
 * @method componentBindItemsByParams(array|\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $params)
 */
class CustomizedComponent {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建促销活动
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentCmd $createComponentCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\CreateComponentCmd $createComponentCmd) {
        return self::getClass()->create($createComponentCmd);
    }


    /**
     * 更新促销活动
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentCmd $updateComponentCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\UpdateComponentCmd $updateComponentCmd) {
        return self::getClass()->update($updateComponentCmd);
    }


    /**
     * 更新促销活动
     *
     * @param  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 促销活动详情
     *
     * @param  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO"
        );
    }

    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListWithPaginateCmd $componentListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentListWithPaginateDTO
     */
    public static function listWithPaginate (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListWithPaginateCmd $componentListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWithPaginate($componentListWithPaginateCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentListWithPaginateDTO"
        );
    }


    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO[]
     */
    public static function list (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($componentListCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentDetailDTO[]"
        );
    }


    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createComponentItem (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd) {
        return self::getClass()->createComponentItem($componentListCmd);
    }


    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateComponentItem (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd) {
        return self::getClass()->updateComponentItem($componentListCmd);
    }


    /**
     * 促销活动列表
     *
     * @support  int $id 模版组类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteComponentItem () {
        return self::getClass()->deleteComponentItem([
        ]);
    }

    /**
     * 促销活动列表
     *
     * @support  int $id 模版组类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function componentItemList () {
        return self::getClass()->componentItemList([
        ]);
    }

    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginateCmd $componentItemListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemListWithPaginateDTO
     */
    public static function componentItemListWithPaginate (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentItemListWithPaginateCmd $componentItemListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->componentItemListWithPaginate($componentItemListWithPaginateCmd),
            "\Mainto\Bridge\Structs\HimoRetailProduct\Customized\DTO\ComponentItemListWithPaginateDTO"
        );
    }


    /**
     * 促销活动列表
     *
     * @var  \Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function componentBindItems (\Mainto\Bridge\Structs\HimoRetailProduct\Customized\Cmd\ComponentListCmd $componentListCmd) {
        return self::getClass()->componentBindItems($componentListCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoRetailProduct', 'Customized\CustomizedComponent');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoRetailProduct', 'Customized\CustomizedComponent');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}